/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import java.lang.Object;
import elemental2.Global.WebkitRTCPeerConnectionAIceServersType;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import elemental2.Database;
import elemental2.FileSystem;
import elemental2.FileError;
import elemental2.IdleDeadline;
import elemental2.Entry;
import elemental2.CSSInterface;
import elemental2.Global.FontFaceLoadStatusType;
import elemental2.Global.FontFaceSetLoadStatusType;
import elemental2.JSONType;
import elemental2.Global.PermissionNameType;
import elemental2.Global.PermissionStateType;
import elemental2.Global.ServiceWorkerStateType;
import elemental2.Global.VisibilityStateType;
import elemental2.DOMApplicationCache;
import elemental2.Arguments;
import elemental2.CacheStorage;
import elemental2.HTMLDocument;
import elemental2.Navigator;
import elemental2.Screen;
import elemental2.Window;
import elemental2.SpeechSynthesis;
import elemental2.Global.WebkitRTCPeerConnectionType;
import elemental2.NativeObject;
import elemental2.Global.MozRequestAnimationFrameCallback;
import elemental2.Element;
import elemental2.Global.MsRequestAnimationFrameCallback;
import elemental2.Global.ORequestAnimationFrameCallback;
import elemental2.Global.OpenDatabaseOpt_callback;
import elemental2.DatabaseCallback;
import elemental2.Transferable;
import elemental2.Global.RequestAnimationFrameCallback;
import elemental2.Global.RequestFileSystemSuccessCallback;
import elemental2.Global.RequestFileSystemErrorCallback;
import elemental2.Global.RequestIdleCallbackCallback;
import elemental2.Global.RequestIdleCallbackOpt_optionsType;
import elemental2.Global.ResolveLocalFileSystemURISuccessCallback;
import elemental2.Global.ResolveLocalFileSystemURIErrorCallback;
import elemental2.Global.SetImmediateCallback;
import elemental2.Global.SetIntervalCallback;
import elemental2.Global.SetTimeoutCallback;
import elemental2.Global.WebkitRequestAnimationFrameCallback;
import elemental2.Global.WebkitRequestFileSystemSuccessCallback;
import elemental2.Global.WebkitRequestFileSystemErrorCallback;
import elemental2.Global.WebkitResolveLocalFileSystemURISuccessCallback;
import elemental2.Global.WebkitResolveLocalFileSystemURIErrorCallback;

@JsType(isNative = true, name = "window", namespace = JsPackage.GLOBAL)
public class Global {
  @JsType
  public interface FontFaceLoadStatusType {
    @JsProperty(name = "ERROR")
    void setERROR(/* FontFaceLoadStatus */ Object ERROR);

    @JsProperty(name = "ERROR")
    /* FontFaceLoadStatus */ Object getERROR();

    @JsProperty(name = "LOADED")
    void setLOADED(/* FontFaceLoadStatus */ Object LOADED);

    @JsProperty(name = "LOADED")
    /* FontFaceLoadStatus */ Object getLOADED();

    @JsProperty(name = "LOADING")
    void setLOADING(/* FontFaceLoadStatus */ Object LOADING);

    @JsProperty(name = "LOADING")
    /* FontFaceLoadStatus */ Object getLOADING();

    @JsProperty(name = "UNLOADED")
    void setUNLOADED(/* FontFaceLoadStatus */ Object UNLOADED);

    @JsProperty(name = "UNLOADED")
    /* FontFaceLoadStatus */ Object getUNLOADED();

  }
  @JsType
  public interface FontFaceSetLoadStatusType {
    @JsProperty(name = "LOADED")
    void setLOADED(/* FontFaceSetLoadStatus */ Object LOADED);

    @JsProperty(name = "LOADED")
    /* FontFaceSetLoadStatus */ Object getLOADED();

    @JsProperty(name = "LOADING")
    void setLOADING(/* FontFaceSetLoadStatus */ Object LOADING);

    @JsProperty(name = "LOADING")
    /* FontFaceSetLoadStatus */ Object getLOADING();

  }
  @JsType
  public interface PermissionNameType {
    @JsProperty(name = "GEOLOCATION")
    void setGEOLOCATION(/* PermissionName */ Object GEOLOCATION);

    @JsProperty(name = "GEOLOCATION")
    /* PermissionName */ Object getGEOLOCATION();

    @JsProperty(name = "MIDI")
    void setMIDI(/* PermissionName */ Object MIDI);

    @JsProperty(name = "MIDI")
    /* PermissionName */ Object getMIDI();

    @JsProperty(name = "NOTIFICATIONS")
    void setNOTIFICATIONS(/* PermissionName */ Object NOTIFICATIONS);

    @JsProperty(name = "NOTIFICATIONS")
    /* PermissionName */ Object getNOTIFICATIONS();

    @JsProperty(name = "PUSH")
    void setPUSH(/* PermissionName */ Object PUSH);

    @JsProperty(name = "PUSH")
    /* PermissionName */ Object getPUSH();

  }
  @JsType
  public interface PermissionStateType {
    @JsProperty(name = "DENIED")
    void setDENIED(/* PermissionState */ Object DENIED);

    @JsProperty(name = "DENIED")
    /* PermissionState */ Object getDENIED();

    @JsProperty(name = "GRANTED")
    void setGRANTED(/* PermissionState */ Object GRANTED);

    @JsProperty(name = "GRANTED")
    /* PermissionState */ Object getGRANTED();

    @JsProperty(name = "PROMPT")
    void setPROMPT(/* PermissionState */ Object PROMPT);

    @JsProperty(name = "PROMPT")
    /* PermissionState */ Object getPROMPT();

  }
  @JsType
  public interface ServiceWorkerStateType {
    @JsProperty(name = "ACTIVATED")
    void setACTIVATED(/* ServiceWorkerState */ Object ACTIVATED);

    @JsProperty(name = "ACTIVATED")
    /* ServiceWorkerState */ Object getACTIVATED();

    @JsProperty(name = "ACTIVATING")
    void setACTIVATING(/* ServiceWorkerState */ Object ACTIVATING);

    @JsProperty(name = "ACTIVATING")
    /* ServiceWorkerState */ Object getACTIVATING();

    @JsProperty(name = "INSTALLED")
    void setINSTALLED(/* ServiceWorkerState */ Object INSTALLED);

    @JsProperty(name = "INSTALLED")
    /* ServiceWorkerState */ Object getINSTALLED();

    @JsProperty(name = "INSTALLING")
    void setINSTALLING(/* ServiceWorkerState */ Object INSTALLING);

    @JsProperty(name = "INSTALLING")
    /* ServiceWorkerState */ Object getINSTALLING();

    @JsProperty(name = "REDUNDANT")
    void setREDUNDANT(/* ServiceWorkerState */ Object REDUNDANT);

    @JsProperty(name = "REDUNDANT")
    /* ServiceWorkerState */ Object getREDUNDANT();

  }
  @JsType
  public interface VisibilityStateType {
    @JsProperty(name = "HIDDEN")
    void setHIDDEN(/* VisibilityState */ Object HIDDEN);

    @JsProperty(name = "HIDDEN")
    /* VisibilityState */ Object getHIDDEN();

    @JsProperty(name = "PRERENDER")
    void setPRERENDER(/* VisibilityState */ Object PRERENDER);

    @JsProperty(name = "PRERENDER")
    /* VisibilityState */ Object getPRERENDER();

    @JsProperty(name = "UNLOADED")
    void setUNLOADED(/* VisibilityState */ Object UNLOADED);

    @JsProperty(name = "UNLOADED")
    /* VisibilityState */ Object getUNLOADED();

    @JsProperty(name = "VISIBLE")
    void setVISIBLE(/* VisibilityState */ Object VISIBLE);

    @JsProperty(name = "VISIBLE")
    /* VisibilityState */ Object getVISIBLE();

  }
  @JsType
  public interface RequestIdleCallbackOpt_optionsType {
    @JsProperty
    void setTimeout(double timeout);

    @JsProperty
    double getTimeout();

  }
  @JsType
  public interface WebkitRTCPeerConnectionType {
    
    
    
  }
  @JsType
  public interface WebkitRTCPeerConnectionAType {
    @JsProperty
    void setIceServers(WebkitRTCPeerConnectionAIceServersType[] iceServers);

    @JsProperty
    WebkitRTCPeerConnectionAIceServersType[] getIceServers();

  }
  @JsType
  public interface WebkitRTCPeerConnectionAIceServersType {
    @JsProperty
    void setUrl(String url);

    @JsProperty
    String getUrl();

  }
  @JsFunction
  public interface MozRequestAnimationFrameCallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface MsRequestAnimationFrameCallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface ORequestAnimationFrameCallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface OpenDatabaseOpt_callback {
    Object onInvoke(Database a);

  }
  @JsFunction
  public interface RequestAnimationFrameCallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface RequestFileSystemSuccessCallback {
    Object onInvoke(FileSystem a);

  }
  @JsFunction
  public interface RequestFileSystemErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface RequestIdleCallbackCallback {
    Object onInvoke(IdleDeadline a);

  }
  @JsFunction
  public interface ResolveLocalFileSystemURISuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface ResolveLocalFileSystemURIErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface SetImmediateCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface SetIntervalCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface SetTimeoutCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface WebkitRequestAnimationFrameCallback {
    Object onInvoke(double a);

  }
  @JsFunction
  public interface WebkitRequestFileSystemSuccessCallback {
    Object onInvoke(FileSystem a);

  }
  @JsFunction
  public interface WebkitRequestFileSystemErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface WebkitResolveLocalFileSystemURISuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface WebkitResolveLocalFileSystemURIErrorCallback {
    Object onInvoke(FileError a);

  }
  public static CSSInterface CSS;
  public static FontFaceLoadStatusType FontFaceLoadStatus;
  public static FontFaceSetLoadStatusType FontFaceSetLoadStatus;
  public static double Infinity;
  public static JSONType JSON;
  public static double NaN;
  public static PermissionNameType PermissionName;
  public static PermissionStateType PermissionState;
  public static ServiceWorkerStateType ServiceWorkerState;
  public static VisibilityStateType VisibilityState;
  public static DOMApplicationCache applicationCache;
  public static Arguments<Object> arguments;
  public static CacheStorage caches;
  public static HTMLDocument document;
  public static Navigator navigator;
  public static Screen screen;
  public static Window self;
  public static SpeechSynthesis speechSynthesis;
  public static Window top;
  public static Object undefined;
  public static Object webkitMediaStream;
  public static WebkitRTCPeerConnectionType webkitRTCPeerConnection;
  public static Window window;
  
  public static native Object ActiveXObject(Object... a);

  public static native Object Function(Object... var_args);

  public static native String ScriptEngine();

  public static native double ScriptEngineBuildVersion();

  public static native double ScriptEngineMajorVersion();

  public static native double ScriptEngineMinorVersion();

  public static native Object Symbol(String description);

  public static native Object alert(Object x);

  public static native Object cancelAnimationFrame(double handle);

  public static native Object cancelIdleCallback(double handle);

  public static native Object cancelRequestAnimationFrame(double handle);

  public static native Object clearImmediate(double immediateID);

  public static native Object clearInterval(double intervalID);

  public static native Object clearTimeout(double timeoutID);

  public static native boolean confirm(Object message);

  public static native String createObjectURL(NativeObject obj);

  public static native String decodeURI(String uri);

  public static native String decodeURIComponent(String uri);

  public static native Object dump(Object x);

  public static native String encodeURI(String uri);

  public static native String encodeURIComponent(String uri);

  public static native String escape(String str);

  public static native Object eval(String code);

  public static native boolean hasOwnProperty(Object propertyName);

  public static native Object importScripts(String... var_args);

  public static native boolean isFinite(Object num);

  public static native boolean isNaN(Object num);

  public static native Object mozCancelAnimationFrame(double handle);

  public static native Object mozCancelRequestAnimationFrame(double handle);

  public static native double mozRequestAnimationFrame(MozRequestAnimationFrameCallback callback, Element element);

  public static native double mozRequestAnimationFrame(MozRequestAnimationFrameCallback callback);

  public static native Object msCancelAnimationFrame(double handle);

  public static native Object msCancelRequestAnimationFrame(double handle);

  public static native double msRequestAnimationFrame(MsRequestAnimationFrameCallback callback, Element element);

  public static native double msRequestAnimationFrame(MsRequestAnimationFrameCallback callback);

  public static native Object oCancelAnimationFrame(double handle);

  public static native Object oCancelRequestAnimationFrame(double handle);

  public static native double oRequestAnimationFrame(ORequestAnimationFrameCallback callback, Element element);

  public static native double oRequestAnimationFrame(ORequestAnimationFrameCallback callback);

  public static native Database openDatabase(String name, String version, String description, double size, OpenDatabaseOpt_callback callback);

  public static native Database openDatabase(String name, String version, String description, double size);

  public static native Database openDatabase(String name, String version, String description, double size, DatabaseCallback callback);

  public static native double parseFloat(Object num);

  public static native double parseInt(Object num, double base);

  public static native void postMessage(Object message, Transferable[] targetOriginOrTransfer, Object[] targetOriginOrPortsOrTransfer);

  public static native void postMessage(Object message);

  public static native void postMessage(Object message, String targetOriginOrTransfer, Object[] targetOriginOrPortsOrTransfer);

  public static native void postMessage(Object message, Transferable[] targetOriginOrTransfer);

  public static native void postMessage(Object message, String targetOriginOrTransfer);

  public static native void postMessage(Object message, String targetOriginOrTransfer, String targetOriginOrPortsOrTransfer);

  public static native void postMessage(Object message, Transferable[] targetOriginOrTransfer, String targetOriginOrPortsOrTransfer);

  public static native String prompt(String message, String value);

  public static native String prompt(String message);

  public static native double requestAnimationFrame(RequestAnimationFrameCallback callback, Element element);

  public static native double requestAnimationFrame(RequestAnimationFrameCallback callback);

  public static native Object requestFileSystem(double type, double size, RequestFileSystemSuccessCallback successCallback, RequestFileSystemErrorCallback errorCallback);

  public static native Object requestFileSystem(double type, double size, RequestFileSystemSuccessCallback successCallback);

  public static native double requestIdleCallback(RequestIdleCallbackCallback callback, RequestIdleCallbackOpt_optionsType options);

  public static native double requestIdleCallback(RequestIdleCallbackCallback callback);

  public static native double requestIdleCallback(RequestIdleCallbackCallback callback, double options);

  public static native Object resolveLocalFileSystemURI(String uri, ResolveLocalFileSystemURISuccessCallback successCallback, ResolveLocalFileSystemURIErrorCallback errorCallback);

  public static native Object resolveLocalFileSystemURI(String uri, ResolveLocalFileSystemURISuccessCallback successCallback);

  public static native Object revokeObjectURL(String url);

  public static native double setImmediate(SetImmediateCallback callback);

  public static native double setInterval(String callback, double delay);

  public static native double setInterval(SetIntervalCallback callback, double delay);

  public static native double setInterval(String callback);

  public static native double setInterval(SetIntervalCallback callback);

  public static native double setTimeout(String callback, double delay, Object... var_args);

  public static native double setTimeout(SetTimeoutCallback callback, double delay, Object... var_args);

  public static native double setTimeout(String callback);

  public static native double setTimeout(SetTimeoutCallback callback);

  public static native String unescape(String str);

  public static native Object webkitCancelAnimationFrame(double handle);

  public static native Object webkitCancelRequestAnimationFrame(double handle);

  public static native double webkitRequestAnimationFrame(WebkitRequestAnimationFrameCallback callback, Element element);

  public static native double webkitRequestAnimationFrame(WebkitRequestAnimationFrameCallback callback);

  public static native Object webkitRequestFileSystem(double type, double size, WebkitRequestFileSystemSuccessCallback successCallback, WebkitRequestFileSystemErrorCallback errorCallback);

  public static native Object webkitRequestFileSystem(double type, double size, WebkitRequestFileSystemSuccessCallback successCallback);

  public static native Object webkitResolveLocalFileSystemURI(String uri, WebkitResolveLocalFileSystemURISuccessCallback successCallback, WebkitResolveLocalFileSystemURIErrorCallback errorCallback);

  public static native Object webkitResolveLocalFileSystemURI(String uri, WebkitResolveLocalFileSystemURISuccessCallback successCallback);

  
}
