/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.GeolocationPosition;
import elemental2.GeolocationPositionError;
import elemental2.Geolocation.GetCurrentPositionSuccessCallback;
import elemental2.Geolocation.GetCurrentPositionOpt_errorCallback;
import elemental2.GeolocationPositionOptions;
import elemental2.Geolocation.WatchPositionSuccessCallback;
import elemental2.Geolocation.WatchPositionOpt_errorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Geolocation {
  @JsFunction
  public interface GetCurrentPositionSuccessCallback {
    Object onInvoke(GeolocationPosition a);

  }
  @JsFunction
  public interface GetCurrentPositionOpt_errorCallback {
    Object onInvoke(GeolocationPositionError a);

  }
  @JsFunction
  public interface WatchPositionSuccessCallback {
    Object onInvoke(GeolocationPosition a);

  }
  @JsFunction
  public interface WatchPositionOpt_errorCallback {
    Object onInvoke(GeolocationPositionError a);

  }
  public native Object clearWatch(double watchId);

  public native Object getCurrentPosition(GetCurrentPositionSuccessCallback successCallback, GetCurrentPositionOpt_errorCallback errorCallback, GeolocationPositionOptions options);

  public native Object getCurrentPosition(GetCurrentPositionSuccessCallback successCallback);

  public native Object getCurrentPosition(GetCurrentPositionSuccessCallback successCallback, GetCurrentPositionOpt_errorCallback errorCallback);

  public native double watchPosition(WatchPositionSuccessCallback successCallback, WatchPositionOpt_errorCallback errorCallback, GeolocationPositionOptions options);

  public native double watchPosition(WatchPositionSuccessCallback successCallback);

  public native double watchPosition(WatchPositionSuccessCallback successCallback, WatchPositionOpt_errorCallback errorCallback);

}
