/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.FontFace;
import elemental2.Event;
import java.lang.String;
import elemental2.FontFaceSet.ForEachCbCallback;
import elemental2.NativeObject;
import elemental2.Promise;
import jsinterop.annotations.JsProperty;
import elemental2.FontFaceSet.OnloadingCallback;
import elemental2.FontFaceSet.OnloadingdoneCallback;
import elemental2.FontFaceSet.OnloadingerrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface FontFaceSet {
  @JsFunction
  public interface ForEachCbCallback {
    Object onInvoke(FontFace a, double b, FontFaceSet c);

  }
  @JsFunction
  public interface OnloadingCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadingdoneCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadingerrorCallback {
    Object onInvoke(Event a);

  }
  Object add(FontFace value);

  boolean check(String font, String text);

  boolean check(String font);

  Object clear();

  Object delete(FontFace value);

  Object forEach(ForEachCbCallback cb, NativeObject selfObj);

  Object forEach(ForEachCbCallback cb);

  boolean has(FontFace font);

  Promise<FontFace[]> load(String font, String text);

  Promise<FontFace[]> load(String font);

  @JsProperty
  void setOnloading(OnloadingCallback onloading);

  @JsProperty
  OnloadingCallback getOnloading();

  @JsProperty
  void setOnloadingdone(OnloadingdoneCallback onloadingdone);

  @JsProperty
  OnloadingdoneCallback getOnloadingdone();

  @JsProperty
  void setOnloadingerror(OnloadingerrorCallback onloadingerror);

  @JsProperty
  OnloadingerrorCallback getOnloadingerror();

  @JsProperty
  void setReady(Promise<FontFaceSet> ready);

  @JsProperty
  Promise<FontFaceSet> getReady();

  @JsProperty
  void setStatus(/* FontFaceSetLoadStatus */ Object status);

  @JsProperty
  /* FontFaceSetLoadStatus */ Object getStatus();

}
