/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import java.lang.Object;
import elemental2.ArrayBufferView;
import elemental2.FontFace.FontFace_InstanceDescriptorsType;
import elemental2.ArrayBuffer;
import elemental2.Promise;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FontFace {
  @JsType
  public interface FontFace_InstanceDescriptorsType {
    @JsProperty
    void setFeatureSettings(String featureSettings);

    @JsProperty
    String getFeatureSettings();

    @JsProperty
    void setStretch(String stretch);

    @JsProperty
    String getStretch();

    @JsProperty
    void setStyle(String style);

    @JsProperty
    String getStyle();

    @JsProperty
    void setUnicodeRange(String unicodeRange);

    @JsProperty
    String getUnicodeRange();

    @JsProperty
    void setVariant(String variant);

    @JsProperty
    String getVariant();

    @JsProperty
    void setWeight(String weight);

    @JsProperty
    String getWeight();

  }
  public String family;
  public String featureSettings;
  public /* FontFaceLoadStatus */ Object status;
  public String stretch;
  public String style;
  public String unicodeRange;
  public String variant;
  public String weight;
  
  public FontFace(String fontFamily, ArrayBufferView source, FontFace_InstanceDescriptorsType descriptors) {}

  public FontFace(String fontFamily, String source, FontFace_InstanceDescriptorsType descriptors) {}

  public FontFace(String fontFamily, ArrayBuffer source, FontFace_InstanceDescriptorsType descriptors) {}

  public native Promise<FontFace> load();

}
