/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.ProgressEvent;
import elemental2.FileError;
import elemental2.FileSaver.OnabortCallback;
import elemental2.FileSaver.OnerrorCallback;
import elemental2.FileSaver.OnprogressCallback;
import elemental2.FileSaver.OnwriteCallback;
import elemental2.FileSaver.OnwriteendCallback;
import elemental2.FileSaver.OnwritestartCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FileSaver {
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnprogressCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnwriteCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnwriteendCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnwritestartCallback {
    Object onInvoke(ProgressEvent a);

  }
  public double DONE;
  public double INIT;
  public double WRITING;
  public FileError error;
  public OnabortCallback onabort;
  public OnerrorCallback onerror;
  public OnprogressCallback onprogress;
  public OnwriteCallback onwrite;
  public OnwriteendCallback onwriteend;
  public OnwritestartCallback onwritestart;
  public double readyState;
  
  public native Object abort();

}
