/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.ProgressEvent;
import elemental2.FileError;
import elemental2.FileReader.OnabortCallback;
import elemental2.FileReader.OnerrorCallback;
import elemental2.FileReader.OnloadCallback;
import elemental2.FileReader.OnloadendCallback;
import elemental2.FileReader.OnloadstartCallback;
import elemental2.FileReader.OnprogressCallback;
import java.lang.String;
import elemental2.FileReader.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.Blob;
import elemental2.FileReader.RemoveEventListenerListenerCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FileReader implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnloadCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnloadendCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnloadstartCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface OnprogressCallback {
    Object onInvoke(ProgressEvent a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public static double DONE;
  public static double EMPTY;
  public static double LOADING;
  
  public FileError error;
  public OnabortCallback onabort;
  public OnerrorCallback onerror;
  public OnloadCallback onload;
  public OnloadendCallback onloadend;
  public OnloadstartCallback onloadstart;
  public OnprogressCallback onprogress;
  public double readyState;
  public /* String | Blob | ArrayBuffer */ Object result;
  
  public native Object abort();

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native Object readAsArrayBuffer(Blob blob);

  public native Object readAsBinaryString(Blob blob);

  public native Object readAsDataURL(Blob blob);

  public native Object readAsText(Blob blob, String encoding);

  public native Object readAsText(Blob blob);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
