/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.DOMError;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FileError extends DOMError {
  public static double ABORT_ERR;
  public static double ENCODING_ERR;
  public static double INVALID_MODIFICATION_ERR;
  public static double INVALID_STATE_ERR;
  public static double NOT_FOUND_ERR;
  public static double NOT_READABLE_ERR;
  public static double NO_MODIFICATION_ALLOWED_ERR;
  public static double PATH_EXISTS_ERR;
  public static double QUOTA_EXCEEDED_ERR;
  public static double SECURITY_ERR;
  public static double SYNTAX_ERR;
  public static double TYPE_MISMATCH_ERR;
  
  public double code;
  
  
}
