/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Entry;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.FileWriter;
import elemental2.FileError;
import elemental2.File;
import elemental2.FileEntry.CreateWriterSuccessCallback;
import elemental2.FileEntry.CreateWriterErrorCallback;
import elemental2.FileEntry.FileSuccessCallback;
import elemental2.FileEntry.FileErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FileEntry extends Entry {
  @JsFunction
  public interface CreateWriterSuccessCallback {
    Object onInvoke(FileWriter a);

  }
  @JsFunction
  public interface CreateWriterErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface FileSuccessCallback {
    Object onInvoke(File a);

  }
  @JsFunction
  public interface FileErrorCallback {
    Object onInvoke(FileError a);

  }
  public native Object createWriter(CreateWriterSuccessCallback successCallback, CreateWriterErrorCallback errorCallback);

  public native Object createWriter(CreateWriterSuccessCallback successCallback);

  public native Object file(FileSuccessCallback successCallback, FileErrorCallback errorCallback);

  public native Object file(FileSuccessCallback successCallback);

}
