/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Blob;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.Date;
import java.lang.Object;
import elemental2.File.File_InstanceOpt_propertiesType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class File extends Blob {
  @JsType
  public interface File_InstanceOpt_propertiesType {
    @JsProperty
    void setLastModified(double lastModified);

    @JsProperty
    double getLastModified();

    @JsProperty
    void setType(String type);

    @JsProperty
    String getType();

  }
  public String fileName;
  public String fileSize;
  public double lastModified;
  public Date lastModifiedDate;
  public String name;
  
  public File(/* String | Blob | ArrayBuffer */ Object[] contents, String name, File_InstanceOpt_propertiesType properties) {}

  public File() {}

  public File(/* String | Blob | ArrayBuffer */ Object[] contents) {}

  public File(/* String | Blob | ArrayBuffer */ Object[] contents, String name) {}

  
}
