/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Event;
import jsinterop.annotations.JsProperty;
import elemental2.ServiceWorkerClient;
import java.lang.Object;
import java.lang.String;
import elemental2.FetchEvent.FetchEvent_InstanceOpt_eventInitDictType;
import elemental2.Event.Event_InstanceOpt_eventInitDictType;
import jsinterop.annotations.JsMethod;
import elemental2.Promise;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FetchEvent extends Event {
  @JsType
  public interface FetchEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

    @JsProperty
    void setClient(ServiceWorkerClient client);

    @JsProperty
    ServiceWorkerClient getClient();

    @JsProperty
    void setIsReload(boolean isReload);

    @JsProperty
    boolean isIsReload();

    @JsProperty
    void setRequest(Object request);

    @JsProperty
    Object getRequest();

  }
  public ServiceWorkerClient client;
  public boolean isReload;
  public Object request;
  
  public FetchEvent(String type, FetchEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (Event_InstanceOpt_eventInitDictType) null);
  }

  public FetchEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (Event_InstanceOpt_eventInitDictType) null);
  }

  @JsMethod(name = "default")
  public native Promise<Object> default_();

  public native Promise<Object> forwardTo(String url);

  public native Object respondWith(Promise<Object> r);

  public native Object respondWith(Object r);

}
