/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.MessageEvent;
import elemental2.DataTransfer;
import elemental2.EventSource.OnerrorCallback;
import elemental2.EventSource.OnmessageCallback;
import elemental2.EventSource.OnopenCallback;
import java.lang.String;
import elemental2.NativeObject;
import elemental2.EventSource.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.EventSource.RemoveEventListenerListenerCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class EventSource implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmessageCallback<Object> {
    Object onInvoke(MessageEvent<Object> a);

  }
  @JsFunction
  public interface OnopenCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public double CLOSED;
  public double CONNECTING;
  public double OPEN;
  public DataTransfer clipboardData;
  public OnerrorCallback onerror;
  public OnmessageCallback onmessage;
  public OnopenCallback onopen;
  public double readyState;
  public String url;
  public boolean withCredentials;
  
  public EventSource(String url, NativeObject eventSourceInitDict) {}

  public EventSource(String url) {}

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object close();

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
