/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsFunction;
import elemental2.EventTarget;
import elemental2.Event.DeepPathCallback;
import java.lang.String;
import elemental2.Element;
import elemental2.Event.Event_InstanceOpt_eventInitDictType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Event {
  @JsType
  public interface Event_InstanceOpt_eventInitDictType {
    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

  }
  @JsFunction
  public interface DeepPathCallback {
    EventTarget[] onInvoke();

  }
  public static double AT_TARGET;
  public static double BUBBLING_PHASE;
  public static double CAPTURING_PHASE;
  
  public boolean bubbles;
  public boolean cancelable;
  public EventTarget currentTarget;
  public DeepPathCallback deepPath;
  public boolean defaultPrevented;
  public double eventPhase;
  public String namespaceURI;
  public Element[] path;
  public EventTarget target;
  public double timeStamp;
  public String type;
  
  public Event(String type, Event_InstanceOpt_eventInitDictType eventInitDict) {}

  public Event(String type) {}

  public native void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg);

  public native void preventDefault();

  public native void stopImmediatePropagation();

  public native void stopPropagation();

}
