/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.NativeObject;
import elemental2.Error.CaptureStackTraceOpt_constructorCallback;
import elemental2.Error.CaptureStackTraceOpt_constructorCallback0;
import java.lang.String;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Error {
  @JsFunction
  public interface CaptureStackTraceOpt_constructorCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface CaptureStackTraceOpt_constructorCallback0 {
    Object onInvoke(Object... a);

  }
  public static double stackTraceLimit;
  
  public static native Object captureStackTrace(NativeObject error, CaptureStackTraceOpt_constructorCallback constructor);

  public static native Object captureStackTrace(NativeObject error);

  public static native Object captureStackTrace(NativeObject error, CaptureStackTraceOpt_constructorCallback0 constructor);

  public String description;
  public String fileName;
  public double lineNumber;
  public String message;
  public String name;
  public Object sourceURL;
  public String stack;
  
  public Error(Object message, Object file, Object line) {}

  public Error() {}

  public Error(Object message) {}

  public Error(Object message, Object file) {}

  
}
