/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.FileError;
import elemental2.Metadata;
import elemental2.FileSystem;
import java.lang.String;
import elemental2.DirectoryEntry;
import elemental2.Entry.CopyToSuccessCallback;
import elemental2.Entry.CopyToErrorCallback;
import elemental2.Entry.GetMetadataSuccessCallback;
import elemental2.Entry.GetMetadataErrorCallback;
import elemental2.Entry.GetParentSuccessCallback;
import elemental2.Entry.GetParentErrorCallback;
import elemental2.Entry.MoveToSuccessCallback;
import elemental2.Entry.MoveToErrorCallback;
import elemental2.Entry.RemoveSuccessCallback;
import elemental2.Entry.RemoveErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Entry {
  @JsFunction
  public interface CopyToSuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface CopyToErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface GetMetadataSuccessCallback {
    Object onInvoke(Metadata a);

  }
  @JsFunction
  public interface GetMetadataErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface GetParentSuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface GetParentErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface MoveToSuccessCallback {
    Object onInvoke(Entry a);

  }
  @JsFunction
  public interface MoveToErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface RemoveSuccessCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface RemoveErrorCallback {
    Object onInvoke(FileError a);

  }
  public FileSystem filesystem;
  public String fullPath;
  public boolean isDirectory;
  public boolean isFile;
  public String name;
  
  public native Object copyTo(DirectoryEntry parent, String newName, CopyToSuccessCallback successCallback, CopyToErrorCallback errorCallback);

  public native Object copyTo(DirectoryEntry parent);

  public native Object copyTo(DirectoryEntry parent, String newName);

  public native Object copyTo(DirectoryEntry parent, String newName, CopyToSuccessCallback successCallback);

  public native Object getMetadata(GetMetadataSuccessCallback successCallback, GetMetadataErrorCallback errorCallback);

  public native Object getMetadata(GetMetadataSuccessCallback successCallback);

  public native Object getParent(GetParentSuccessCallback successCallback, GetParentErrorCallback errorCallback);

  public native Object getParent(GetParentSuccessCallback successCallback);

  public native Object moveTo(DirectoryEntry parent, String newName, MoveToSuccessCallback successCallback, MoveToErrorCallback errorCallback);

  public native Object moveTo(DirectoryEntry parent);

  public native Object moveTo(DirectoryEntry parent, String newName);

  public native Object moveTo(DirectoryEntry parent, String newName, MoveToSuccessCallback successCallback);

  public native Object remove(RemoveSuccessCallback successCallback, RemoveErrorCallback errorCallback);

  public native Object remove(RemoveSuccessCallback successCallback);

  public native String toURL(String mimeType);

  public native String toURL();

}
