/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Node;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import elemental2.TouchEvent;
import elemental2.DOMTokenList;
import elemental2.Element.OnabortCallback;
import elemental2.Element.OnbeforeinputCallback;
import elemental2.Element.OnbeforeunloadCallback;
import elemental2.Element.OnblurCallback;
import elemental2.Element.OnchangeCallback;
import elemental2.Element.OnclickCallback;
import elemental2.Element.OncompositionendCallback;
import elemental2.Element.OncompositionstartCallback;
import elemental2.Element.OncompositionupdateCallback;
import elemental2.Element.OncontextmenuCallback;
import elemental2.Element.OncopyCallback;
import elemental2.Element.OncutCallback;
import elemental2.Element.OndblclickCallback;
import elemental2.Element.OnerrorCallback;
import elemental2.Element.OnfocusCallback;
import elemental2.Element.OnfocusinCallback;
import elemental2.Element.OnfocusoutCallback;
import elemental2.Element.OninputCallback;
import elemental2.Element.OnkeydownCallback;
import elemental2.Element.OnkeypressCallback;
import elemental2.Element.OnkeyupCallback;
import elemental2.Element.OnloadCallback;
import elemental2.Element.OnmousedownCallback;
import elemental2.Element.OnmousemoveCallback;
import elemental2.Element.OnmouseoutCallback;
import elemental2.Element.OnmouseoverCallback;
import elemental2.Element.OnmouseupCallback;
import elemental2.Element.OnmousewheelCallback;
import elemental2.Element.OnpasteCallback;
import elemental2.Element.OnresetCallback;
import elemental2.Element.OnresizeCallback;
import elemental2.Element.OnscrollCallback;
import elemental2.Element.OnselectCallback;
import elemental2.Element.OnsubmitCallback;
import elemental2.Element.OntextinputCallback;
import elemental2.Element.OntouchcancelCallback;
import elemental2.Element.OntouchendCallback;
import elemental2.Element.OntouchmoveCallback;
import elemental2.Element.OntouchstartCallback;
import elemental2.Element.OnunloadCallback;
import elemental2.Element.OnwheelCallback;
import elemental2.TypeInfo;
import elemental2.Attr;
import elemental2.ClientRect;
import elemental2.ClientRectList;
import elemental2.NodeList;
import elemental2.Element.ScrollIntoViewOpt_topType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Element extends Node {
  @JsType
  public interface ScrollIntoViewOpt_topType {
    @JsProperty
    void setBehavior(String behavior);

    @JsProperty
    String getBehavior();

    @JsProperty
    void setBlock(String block);

    @JsProperty
    String getBlock();

  }
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforeinputCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforeunloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnblurCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncompositionendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncompositionstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncompositionupdateCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncontextmenuCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncopyCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndblclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnfocusCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnfocusinCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnfocusoutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OninputCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeydownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeypressCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeyupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousedownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousemoveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoverCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousewheelCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnpasteCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresetCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresizeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnscrollCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnselectCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsubmitCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OntextinputCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OntouchcancelCallback {
    Object onInvoke(TouchEvent a);

  }
  @JsFunction
  public interface OntouchendCallback {
    Object onInvoke(TouchEvent a);

  }
  @JsFunction
  public interface OntouchmoveCallback {
    Object onInvoke(TouchEvent a);

  }
  @JsFunction
  public interface OntouchstartCallback {
    Object onInvoke(TouchEvent a);

  }
  @JsFunction
  public interface OnunloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnwheelCallback {
    Object onInvoke(Event a);

  }
  public static double ALLOW_KEYBOARD_INPUT;
  
  public double childElementCount;
  public DOMTokenList classList;
  public Object className;
  public double clientHeight;
  public double clientLeft;
  public double clientTop;
  public double clientWidth;
  public Element firstElementChild;
  public String innerHTML;
  public Element lastElementChild;
  public Element nextElementSibling;
  public OnabortCallback onabort;
  public OnbeforeinputCallback onbeforeinput;
  public OnbeforeunloadCallback onbeforeunload;
  public OnblurCallback onblur;
  public OnchangeCallback onchange;
  public OnclickCallback onclick;
  public OncompositionendCallback oncompositionend;
  public OncompositionstartCallback oncompositionstart;
  public OncompositionupdateCallback oncompositionupdate;
  public OncontextmenuCallback oncontextmenu;
  public OncopyCallback oncopy;
  public OncutCallback oncut;
  public OndblclickCallback ondblclick;
  public OnerrorCallback onerror;
  public OnfocusCallback onfocus;
  public OnfocusinCallback onfocusin;
  public OnfocusoutCallback onfocusout;
  public OninputCallback oninput;
  public OnkeydownCallback onkeydown;
  public OnkeypressCallback onkeypress;
  public OnkeyupCallback onkeyup;
  public OnloadCallback onload;
  public OnmousedownCallback onmousedown;
  public OnmousemoveCallback onmousemove;
  public OnmouseoutCallback onmouseout;
  public OnmouseoverCallback onmouseover;
  public OnmouseupCallback onmouseup;
  public OnmousewheelCallback onmousewheel;
  public OnpasteCallback onpaste;
  public OnresetCallback onreset;
  public OnresizeCallback onresize;
  public OnscrollCallback onscroll;
  public OnselectCallback onselect;
  public OnsubmitCallback onsubmit;
  public OntextinputCallback ontextinput;
  public OntouchcancelCallback ontouchcancel;
  public OntouchendCallback ontouchend;
  public OntouchmoveCallback ontouchmove;
  public OntouchstartCallback ontouchstart;
  public OnunloadCallback onunload;
  public OnwheelCallback onwheel;
  public Element previousElementSibling;
  public TypeInfo schemaTypeInfo;
  public double scrollHeight;
  public double scrollLeft;
  public double scrollTop;
  public double scrollWidth;
  public String tagName;
  
  public native void blur();

  public native void click();

  public native Element closest(String selectors);

  public native void focus();

  public native String getAttribute(String name, double flags);

  public native String getAttribute(String name);

  public native String getAttributeNS(String namespaceURI, String localName);

  public native Attr getAttributeNode(String name);

  public native Attr getAttributeNodeNS(String namespaceURI, String localName);

  public native ClientRect getBoundingClientRect();

  public native ClientRectList getClientRects();

  public native NodeList<Element> getElementsByTagName(String tagname);

  public native NodeList<Element> getElementsByTagNameNS(String namespaceURI, String localName);

  public native boolean hasAttribute(String name);

  public native boolean hasAttributeNS(String namespaceURI, String localName);

  public native boolean matches(String selectors);

  public native boolean matchesSelector(String selectors, NodeList<Object> refNodes);

  public native boolean matchesSelector(String selectors);

  public native boolean matchesSelector(String selectors, Node refNodes);

  public native boolean mozMatchesSelector(String selectors);

  public native Object mozRequestFullScreen();

  public native Object mozRequestFullScreenWithKeys();

  public native void msExitFullscreen();

  public native boolean msMatchesSelector(String selectors);

  public native void msRequestFullscreen();

  public native boolean oMatchesSelector(String selectors);

  public native Element querySelector(String selectors);

  public native NodeList<Element> querySelectorAll(String selectors);

  public native void remove();

  public native void removeAttribute(String name);

  public native void removeAttributeNS(String namespaceURI, String localName);

  public native Attr removeAttributeNode(Attr oldAttr);

  public native Object requestFullscreen();

  public native Object scrollIntoView(ScrollIntoViewOpt_topType top);

  public native Object scrollIntoView();

  public native Object scrollIntoView(boolean top);

  public native void setAttribute(String name, boolean value);

  public native void setAttribute(String name, String value);

  public native void setAttribute(String name, double value);

  public native void setAttributeNS(String namespaceURI, String qualifiedName, boolean value);

  public native void setAttributeNS(String namespaceURI, String qualifiedName, String value);

  public native void setAttributeNS(String namespaceURI, String qualifiedName, double value);

  public native Attr setAttributeNode(Attr newAttr);

  public native Attr setAttributeNodeNS(Attr newAttr);

  public native void setIdAttribute(String name, boolean isId);

  public native void setIdAttributeNS(String namespaceURI, String localName, boolean isId);

  public native void setIdAttributeNode(Attr idAttr, boolean isId);

  public native boolean webkitMatchesSelector(String selectors);

  public native Object webkitRequestFullScreen(double allowKeyboardInput);

  public native Object webkitRequestFullScreen();

  public native Object webkitRequestFullscreen(double allowKeyboardInput);

  public native Object webkitRequestFullscreen();

}
