/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Node;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.NativeObject;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.DocumentType;
import elemental2.Element;
import elemental2.DOMConfiguration;
import elemental2.FontFaceSet;
import elemental2.HTMLHeadElement;
import elemental2.DOMImplementation;
import elemental2.CaretPosition;
import elemental2.Attr;
import elemental2.CDATASection;
import elemental2.Comment;
import elemental2.DocumentFragment;
import elemental2.EntityReference;
import elemental2.ProcessingInstruction;
import elemental2.Text;
import elemental2.Touch;
import elemental2.Window;
import elemental2.EventTarget;
import elemental2.TouchList;
import elemental2.NodeList;
import elemental2.Document.RegisterBType;
import elemental2.Document.RegisterElementCallback;
import elemental2.Document.RegisterElementBType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Document extends Node {
  @JsType
  public interface RegisterBType {
    @JsProperty
    void setExtends(String extends_);

    @JsProperty
    String getExtends();

    @JsProperty
    void setPrototype(NativeObject prototype);

    @JsProperty
    NativeObject getPrototype();

  }
  @JsType
  public interface RegisterElementBType {
    @JsProperty
    void setExtends(String extends_);

    @JsProperty
    String getExtends();

    @JsProperty
    void setPrototype(NativeObject prototype);

    @JsProperty
    NativeObject getPrototype();

  }
  @JsFunction
  public interface RegisterElementCallback {
    Object onInvoke(Object... a);

  }
  public double childElementCount;
  public Object currentScript;
  public DocumentType doctype;
  public Element documentElement;
  public String documentURI;
  public DOMConfiguration domConfig;
  public Element firstElementChild;
  public FontFaceSet fonts;
  public Element fullscreenElement;
  public boolean fullscreenEnabled;
  public HTMLHeadElement head;
  public boolean hidden;
  public DOMImplementation implementation;
  public String inputEncoding;
  public Element lastElementChild;
  public boolean mozFullScreen;
  public Element mozFullScreenElement;
  public boolean mozFullScreenEnabled;
  public boolean mozHidden;
  public String mozVisibilityState;
  public Element msFullscreenElement;
  public boolean msFullscreenEnabled;
  public boolean msHidden;
  public String msVisibilityState;
  public Element scrollingElement;
  public boolean strictErrorChecking;
  public /* VisibilityState */ Object visibilityState;
  public Element webkitCurrentFullScreenElement;
  public boolean webkitFullScreenKeyboardInputAllowed;
  public Element webkitFullscreenElement;
  public boolean webkitHidden;
  public boolean webkitIsFullScreen;
  public String webkitVisibilityState;
  public String xmlEncoding;
  public boolean xmlStandalone;
  public String xmlVersion;
  
  public native Node adoptNode(Node externalNode);

  public native CaretPosition caretPositionFromPoint(double x, double y);

  public native Attr createAttribute(String name);

  public native Attr createAttributeNS(String namespaceURI, String qualifiedName);

  public native CDATASection createCDATASection(String data);

  public native Comment createComment(String data);

  public native DocumentFragment createDocumentFragment();

  public native Element createElement(String tagName, String typeExtension);

  public native Element createElement(String tagName);

  public native Element createElementNS(String namespaceURI, String qualifiedName, String typeExtension);

  public native Element createElementNS(String namespaceURI, String qualifiedName);

  public native EntityReference createEntityReference(String name);

  public native ProcessingInstruction createProcessingInstruction(String target, String data);

  public native Text createTextNode(String data);

  public native Text createTextNode(double data);

  public native Touch createTouch(Window view, EventTarget target, double identifier, double pageX, double pageY, double screenX, double screenY);

  public native TouchList createTouchList(Touch[] touches);

  public native Element elementFromPoint(double x, double y);

  public native Object exitFullscreen();

  public native Element getElementById(String s);

  public native NodeList<Element> getElementsByTagName(String tagname);

  public native NodeList<Element> getElementsByTagNameNS(String namespace, String name);

  public native Node importNode(Node externalNode, boolean deep);

  public native Object mozCancelFullScreen();

  public native void normalizeDocument();

  public native Object postMessage(String message);

  public native Element querySelector(String selectors);

  public native NodeList<Element> querySelectorAll(String selectors);

  public native Object register(String a, RegisterBType b);

  public native RegisterElementCallback registerElement(String a, RegisterElementBType b);

  public native RegisterElementCallback registerElement(String a);

  public native Node renameNode(Node n, String namespaceURI, String qualifiedName);

  public native Object webkitCancelFullScreen();

}
