/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Entry;
import elemental2.FileError;
import elemental2.DirectoryReader.ReadEntriesSuccessCallback;
import elemental2.DirectoryReader.ReadEntriesErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class DirectoryReader {
  @JsFunction
  public interface ReadEntriesSuccessCallback {
    Object onInvoke(Entry[] a);

  }
  @JsFunction
  public interface ReadEntriesErrorCallback {
    Object onInvoke(FileError a);

  }
  public native Object readEntries(ReadEntriesSuccessCallback successCallback, ReadEntriesErrorCallback errorCallback);

  public native Object readEntries(ReadEntriesSuccessCallback successCallback);

}
