/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Entry;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.FileError;
import elemental2.FileEntry;
import elemental2.DirectoryReader;
import java.lang.String;
import elemental2.NativeObject;
import elemental2.DirectoryEntry.GetDirectorySuccessCallback;
import elemental2.DirectoryEntry.GetDirectoryErrorCallback;
import elemental2.DirectoryEntry.GetFileSuccessCallback;
import elemental2.DirectoryEntry.GetFileErrorCallback;
import elemental2.DirectoryEntry.RemoveRecursivelySuccessCallback;
import elemental2.DirectoryEntry.RemoveRecursivelyErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class DirectoryEntry extends Entry {
  @JsFunction
  public interface GetDirectorySuccessCallback {
    Object onInvoke(DirectoryEntry a);

  }
  @JsFunction
  public interface GetDirectoryErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface GetFileSuccessCallback {
    Object onInvoke(FileEntry a);

  }
  @JsFunction
  public interface GetFileErrorCallback {
    Object onInvoke(FileError a);

  }
  @JsFunction
  public interface RemoveRecursivelySuccessCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface RemoveRecursivelyErrorCallback {
    Object onInvoke(FileError a);

  }
  public native DirectoryReader createReader();

  public native Object getDirectory(String path, NativeObject options, GetDirectorySuccessCallback successCallback, GetDirectoryErrorCallback errorCallback);

  public native Object getDirectory(String path);

  public native Object getDirectory(String path, NativeObject options);

  public native Object getDirectory(String path, NativeObject options, GetDirectorySuccessCallback successCallback);

  public native Object getFile(String path, NativeObject options, GetFileSuccessCallback successCallback, GetFileErrorCallback errorCallback);

  public native Object getFile(String path);

  public native Object getFile(String path, NativeObject options);

  public native Object getFile(String path, NativeObject options, GetFileSuccessCallback successCallback);

  public native Object removeRecursively(RemoveRecursivelySuccessCallback successCallback, RemoveRecursivelyErrorCallback errorCallback);

  public native Object removeRecursively(RemoveRecursivelySuccessCallback successCallback);

}
