/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import java.lang.String;
import elemental2.NativeObject;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Date {
  public static native double UTC(double year, double month, double date, double hours, double minute, double second, double ms);

  public static native double UTC(double year, double month);

  public static native double UTC(double year, double month, double date);

  public static native double UTC(double year, double month, double date, double hours);

  public static native double UTC(double year, double month, double date, double hours, double minute);

  public static native double UTC(double year, double month, double date, double hours, double minute, double second);

  public static native double now();

  public static native double parse(Object date);

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num, Object sec_num, Object ms_num) {}

  public Date() {}

  public Date(Object yr_num) {}

  public Date(Object yr_num, Object mo_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num, Object sec_num) {}

  public native double getDate();

  public native double getDay();

  public native double getFullYear();

  public native double getHours();

  public native double getMilliseconds();

  public native double getMinutes();

  public native double getMonth();

  public native double getSeconds();

  public native double getTime();

  public native double getTimezoneOffset();

  public native double getUTCDate();

  public native double getUTCDay();

  public native double getUTCFullYear();

  public native double getUTCHours();

  public native double getUTCMilliseconds();

  public native double getUTCMinutes();

  public native double getUTCMonth();

  public native double getUTCSeconds();

  public native double getYear();

  public native Object setDate(double dayValue);

  public native Object setFullYear(double yearValue, double monthValue, double dayValue);

  public native Object setFullYear(double yearValue);

  public native Object setFullYear(double yearValue, double monthValue);

  public native Object setHours(double hoursValue, double minutesValue, double secondsValue, double msValue);

  public native Object setHours(double hoursValue);

  public native Object setHours(double hoursValue, double minutesValue);

  public native Object setHours(double hoursValue, double minutesValue, double secondsValue);

  public native Object setMilliseconds(double millisecondsValue);

  public native Object setMinutes(double minutesValue, double secondsValue, double msValue);

  public native Object setMinutes(double minutesValue);

  public native Object setMinutes(double minutesValue, double secondsValue);

  public native Object setMonth(double monthValue, double dayValue);

  public native Object setMonth(double monthValue);

  public native Object setSeconds(double secondsValue, double msValue);

  public native Object setSeconds(double secondsValue);

  public native Object setTime(double timeValue);

  public native Object setUTCDate(double dayValue);

  public native Object setUTCFullYear(double yearValue, double monthValue, double dayValue);

  public native Object setUTCFullYear(double yearValue);

  public native Object setUTCFullYear(double yearValue, double monthValue);

  public native Object setUTCHours(double hoursValue, double minutesValue, double secondsValue, double msValue);

  public native Object setUTCHours(double hoursValue);

  public native Object setUTCHours(double hoursValue, double minutesValue);

  public native Object setUTCHours(double hoursValue, double minutesValue, double secondsValue);

  public native Object setUTCMilliseconds(double millisecondsValue);

  public native Object setUTCMinutes(double minutesValue, double secondsValue, double msValue);

  public native Object setUTCMinutes(double minutesValue);

  public native Object setUTCMinutes(double minutesValue, double secondsValue);

  public native Object setUTCMonth(double monthValue, double dayValue);

  public native Object setUTCMonth(double monthValue);

  public native Object setUTCSeconds(double secondsValue, double msValue);

  public native Object setUTCSeconds(double secondsValue);

  public native Object setYear(double yearValue);

  public native String toDateString();

  public native String toGMTString();

  public native String toISOString();

  public native String toJSON(Object ignoredKey);

  public native String toJSON();

  public native String toLocaleDateString(String[] locales, NativeObject options);

  public native String toLocaleDateString();

  public native String toLocaleDateString(String locales, NativeObject options);

  public native String toLocaleDateString(String[] locales);

  public native String toLocaleDateString(String locales);

  public native String toLocaleFormat(String formatString);

  public native String toLocaleString(String[] locales, NativeObject options);

  public native String toLocaleString();

  public native String toLocaleString(String locales, NativeObject options);

  public native String toLocaleString(String[] locales);

  public native String toLocaleString(String locales);

  public native String toLocaleTimeString(String[] locales, NativeObject options);

  public native String toLocaleTimeString();

  public native String toLocaleTimeString(String locales, NativeObject options);

  public native String toLocaleTimeString(String[] locales);

  public native String toLocaleTimeString(String locales);

  public native String toSource();

  public native String toString();

  public native String toTimeString();

  public native String toUTCString();

  public native double valueOf();

}
