/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import elemental2.SQLTransaction;
import elemental2.SQLError;
import java.lang.Object;
import java.lang.String;
import elemental2.Database.ChangeVersionCallback;
import elemental2.Database.ChangeVersionErrorCallback;
import elemental2.Database.ChangeVersionSuccessCallback;
import elemental2.Database.ReadTransactionCallback;
import elemental2.Database.ReadTransactionOpt_errorCallback;
import elemental2.Database.ReadTransactionOpt_Callback;
import elemental2.Database.TransactionCallback;
import elemental2.Database.TransactionOpt_errorCallback;
import elemental2.Database.TransactionOpt_Callback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Database {
  @JsFunction
  public interface ChangeVersionCallback {
    void onInvoke(SQLTransaction a);

  }
  @JsFunction
  public interface ChangeVersionErrorCallback {
    void onInvoke(SQLError a);

  }
  @JsFunction
  public interface ChangeVersionSuccessCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ReadTransactionCallback {
    void onInvoke(SQLTransaction a);

  }
  @JsFunction
  public interface ReadTransactionOpt_errorCallback {
    void onInvoke(SQLError a);

  }
  @JsFunction
  public interface ReadTransactionOpt_Callback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface TransactionCallback {
    void onInvoke(SQLTransaction a);

  }
  @JsFunction
  public interface TransactionOpt_errorCallback {
    void onInvoke(SQLError a);

  }
  @JsFunction
  public interface TransactionOpt_Callback {
    Object onInvoke(Object... a);

  }
  public String version;
  
  public native Object changeVersion(String oldVersion, String newVersion, ChangeVersionCallback callback, ChangeVersionErrorCallback errorCallback, ChangeVersionSuccessCallback successCallback);

  public native Object readTransaction(ReadTransactionCallback callback, ReadTransactionOpt_errorCallback errorCallback, ReadTransactionOpt_Callback Callback);

  public native Object readTransaction(ReadTransactionCallback callback);

  public native Object readTransaction(ReadTransactionCallback callback, ReadTransactionOpt_errorCallback errorCallback);

  public native Object transaction(TransactionCallback callback, TransactionOpt_errorCallback errorCallback, TransactionOpt_Callback Callback);

  public native Object transaction(TransactionCallback callback);

  public native Object transaction(TransactionCallback callback, TransactionOpt_errorCallback errorCallback);

}
