/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.ArrayBufferView;
import elemental2.ArrayBuffer;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class DataView extends ArrayBufferView {
  public DataView(ArrayBuffer buffer, double byteOffset, double byteLength) {}

  public DataView(ArrayBuffer buffer) {}

  public DataView(ArrayBuffer buffer, double byteOffset) {}

  public native double getFloat32(double byteOffset, boolean littleEndian);

  public native double getFloat32(double byteOffset);

  public native double getFloat64(double byteOffset, boolean littleEndian);

  public native double getFloat64(double byteOffset);

  public native double getInt16(double byteOffset, boolean littleEndian);

  public native double getInt16(double byteOffset);

  public native double getInt32(double byteOffset, boolean littleEndian);

  public native double getInt32(double byteOffset);

  public native double getInt8(double byteOffset);

  public native double getUint16(double byteOffset, boolean littleEndian);

  public native double getUint16(double byteOffset);

  public native double getUint32(double byteOffset, boolean littleEndian);

  public native double getUint32(double byteOffset);

  public native double getUint8(double byteOffset);

  public native Object setFloat32(double byteOffset, double value, boolean littleEndian);

  public native Object setFloat32(double byteOffset, double value);

  public native Object setFloat64(double byteOffset, double value, boolean littleEndian);

  public native Object setFloat64(double byteOffset, double value);

  public native Object setInt16(double byteOffset, double value, boolean littleEndian);

  public native Object setInt16(double byteOffset, double value);

  public native Object setInt32(double byteOffset, double value, boolean littleEndian);

  public native Object setInt32(double byteOffset, double value);

  public native Object setInt8(double byteOffset, double value);

  public native Object setUint16(double byteOffset, double value, boolean littleEndian);

  public native Object setUint16(double byteOffset, double value);

  public native Object setUint32(double byteOffset, double value, boolean littleEndian);

  public native Object setUint32(double byteOffset, double value);

  public native Object setUint8(double byteOffset, double value);

}
