/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import elemental2.FileList;
import elemental2.DataTransferItemList;
import java.lang.Object;
import elemental2.HTMLElement;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class DataTransfer {
  public String dropEffect;
  public String effectAllowed;
  public FileList files;
  public DataTransferItemList items;
  public String[] types;
  
  public native Object addElement(HTMLElement elem);

  public native Object clearData(String format);

  public native Object clearData();

  public native String getData(String format);

  public native Object setData(String format, String data);

  public native Object setDragImage(HTMLElement img, double x, double y);

}
