/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLCanvasElement;
import java.lang.String;
import elemental2.ImageData;
import elemental2.CanvasGradient;
import elemental2.CanvasPattern;
import elemental2.HTMLImageElement;
import elemental2.HTMLVideoElement;
import elemental2.TextMetrics;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CanvasRenderingContext2D {
  public HTMLCanvasElement canvas;
  public String fillColor;
  public String fillStyle;
  public String font;
  public double globalAlpha;
  public String globalCompositeOperation;
  public String lineCap;
  public double lineDashOffset;
  public String lineJoin;
  public double lineWidth;
  public double miterLimit;
  public double shadowBlur;
  public String shadowColor;
  public double shadowOffsetX;
  public double shadowOffsetY;
  public String strokeColor;
  public String strokeStyle;
  public String textAlign;
  public String textBaseline;
  
  public native void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise);

  public native void arc(double x, double y, double radius, double startAngle, double endAngle);

  public native void arcTo(double x1, double y1, double x2, double y2, double radius);

  public native void beginPath();

  public native void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y);

  public native void clearRect(double x, double y, double w, double h);

  public native void clip(String fillRule);

  public native void clip();

  public native void closePath();

  public native ImageData createImageData(double sw, double sh);

  public native CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1);

  public native CanvasPattern createPattern(HTMLCanvasElement image, String repetition);

  public native CanvasPattern createPattern(HTMLImageElement image, String repetition);

  public native CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw, double sh);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw, double sh);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw, double sh);

  public native void drawImage(HTMLVideoElement image, double dx, double dy);

  public native void drawImage(HTMLImageElement image, double dx, double dy);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh, double sx);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx, double sy);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh, double sx, double sy);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx, double sy);

  public native void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw);

  public native void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw);

  public native void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx, double sy, double sw);

  public native void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise);

  public native void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle);

  public native void fill(String fillRule);

  public native void fill();

  public native void fillRect(double x, double y, double w, double h);

  public native void fillText(String text, double x, double y, double maxWidth);

  public native void fillText(String text, double x, double y);

  public native ImageData getImageData(double sx, double sy, double sw, double sh);

  public native double[] getLineDash();

  public native boolean isPointInPath(double x, double y, String fillRule);

  public native boolean isPointInPath(double x, double y);

  public native boolean isPointInStroke(double x, double y);

  public native void lineTo(double x, double y);

  public native TextMetrics measureText(String text);

  public native void moveTo(double x, double y);

  public native void putImageData(ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY, double dirtyWidth, double dirtyHeight);

  public native void putImageData(ImageData imagedata, double dx, double dy);

  public native void putImageData(ImageData imagedata, double dx, double dy, double dirtyX);

  public native void putImageData(ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY);

  public native void putImageData(ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY, double dirtyWidth);

  public native void quadraticCurveTo(double cpx, double cpy, double x, double y);

  public native void rect(double x, double y, double w, double h);

  public native void restore();

  public native void rotate(double angle);

  public native void save();

  public native void scale(double x, double y);

  public native void setFillColor(String a, double b, double c, double d, double e);

  public native void setFillColor();

  public native void setFillColor(double a, double b, double c, double d, double e);

  public native void setFillColor(String a);

  public native void setFillColor(double a);

  public native void setFillColor(String a, double b);

  public native void setFillColor(double a, double b);

  public native void setFillColor(String a, double b, double c);

  public native void setFillColor(double a, double b, double c);

  public native void setFillColor(String a, double b, double c, double d);

  public native void setFillColor(double a, double b, double c, double d);

  public native void setLineDash(double[] a);

  public native void setStrokeColor(String a, double b, double c, double d, double e);

  public native void setStrokeColor();

  public native void setStrokeColor(double a, double b, double c, double d, double e);

  public native void setStrokeColor(String a);

  public native void setStrokeColor(double a);

  public native void setStrokeColor(String a, double b);

  public native void setStrokeColor(double a, double b);

  public native void setStrokeColor(String a, double b, double c);

  public native void setStrokeColor(double a, double b, double c);

  public native void setStrokeColor(String a, double b, double c, double d);

  public native void setStrokeColor(double a, double b, double c, double d);

  public native void setTransform(double m11, double m12, double m21, double m22, double dx, double dy);

  public native void stroke();

  public native void strokeRect(double x, double y, double w, double h);

  public native void strokeText(String text, double x, double y, double maxWidth);

  public native void strokeText(String text, double x, double y);

  public native void transform(double m11, double m12, double m21, double m22, double dx, double dy);

  public native void translate(double x, double y);

}
