/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.Promise;
import java.lang.Void;
import java.lang.Object;
import java.lang.Boolean;
import elemental2.Cache.DeleteOpt_optionsType;
import elemental2.Cache.KeysOpt_optionsType;
import elemental2.Cache.MatchOpt_optionsType;
import elemental2.Cache.MatchAllOpt_optionsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface Cache {
  @JsType
  public interface DeleteOpt_optionsType {
    @JsProperty
    void setCacheName(String cacheName);

    @JsProperty
    String getCacheName();

    @JsProperty
    void setIgnoreMethod(boolean ignoreMethod);

    @JsProperty
    boolean isIgnoreMethod();

    @JsProperty
    void setIgnoreSearch(boolean ignoreSearch);

    @JsProperty
    boolean isIgnoreSearch();

    @JsProperty
    void setIgnoreVary(boolean ignoreVary);

    @JsProperty
    boolean isIgnoreVary();

    @JsProperty
    void setPrefixMatch(boolean prefixMatch);

    @JsProperty
    boolean isPrefixMatch();

  }
  @JsType
  public interface KeysOpt_optionsType {
    @JsProperty
    void setCacheName(String cacheName);

    @JsProperty
    String getCacheName();

    @JsProperty
    void setIgnoreMethod(boolean ignoreMethod);

    @JsProperty
    boolean isIgnoreMethod();

    @JsProperty
    void setIgnoreSearch(boolean ignoreSearch);

    @JsProperty
    boolean isIgnoreSearch();

    @JsProperty
    void setIgnoreVary(boolean ignoreVary);

    @JsProperty
    boolean isIgnoreVary();

    @JsProperty
    void setPrefixMatch(boolean prefixMatch);

    @JsProperty
    boolean isPrefixMatch();

  }
  @JsType
  public interface MatchOpt_optionsType {
    @JsProperty
    void setCacheName(String cacheName);

    @JsProperty
    String getCacheName();

    @JsProperty
    void setIgnoreMethod(boolean ignoreMethod);

    @JsProperty
    boolean isIgnoreMethod();

    @JsProperty
    void setIgnoreSearch(boolean ignoreSearch);

    @JsProperty
    boolean isIgnoreSearch();

    @JsProperty
    void setIgnoreVary(boolean ignoreVary);

    @JsProperty
    boolean isIgnoreVary();

    @JsProperty
    void setPrefixMatch(boolean prefixMatch);

    @JsProperty
    boolean isPrefixMatch();

  }
  @JsType
  public interface MatchAllOpt_optionsType {
    @JsProperty
    void setCacheName(String cacheName);

    @JsProperty
    String getCacheName();

    @JsProperty
    void setIgnoreMethod(boolean ignoreMethod);

    @JsProperty
    boolean isIgnoreMethod();

    @JsProperty
    void setIgnoreSearch(boolean ignoreSearch);

    @JsProperty
    boolean isIgnoreSearch();

    @JsProperty
    void setIgnoreVary(boolean ignoreVary);

    @JsProperty
    boolean isIgnoreVary();

    @JsProperty
    void setPrefixMatch(boolean prefixMatch);

    @JsProperty
    boolean isPrefixMatch();

  }
  Promise<Void> add(Object request);

  Promise<Void> addAll(Object[] requests);

  Promise<Boolean> delete(Object request, DeleteOpt_optionsType options);

  Promise<Boolean> delete(Object request);

  Promise<Object[]> keys(Object request, KeysOpt_optionsType options);

  Promise<Object[]> keys();

  Promise<Object[]> keys(Object request);

  Promise<Object> match(Object request, MatchOpt_optionsType options);

  Promise<Object> match(Object request);

  Promise<Object[]> matchAll(Object request, MatchAllOpt_optionsType options);

  Promise<Object[]> matchAll();

  Promise<Object[]> matchAll(Object request);

  Promise<Void> put(Object request, Object response);

}
