/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.CSSProperties;
import java.lang.String;
import elemental2.CSSRule;
import java.lang.Object;
import elemental2.CSSValue;
import jsinterop.annotations.JsMethod;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CSSStyleDeclaration extends CSSProperties {
  public String cssText;
  public double length;
  public CSSRule parentRule;
  
  public native Object getAttribute(String name, double flags);

  public native Object getAttribute(String name);

  public native Object getExpression(String name);

  public native CSSValue getPropertyCSSValue(String propertyName);

  public native String getPropertyPriority(String propertyName);

  public native String getPropertyValue(String propertyName);

  public native String item(double index);

  public native boolean removeAttribute(String name, double flags);

  public native boolean removeAttribute(String name);

  public native boolean removeExpression(String name);

  public native String removeProperty(String propertyName);

  public native Object setAttribute(String name, Object value, double flags);

  public native Object setAttribute(String name, Object value);

  public native void setExpression(String name, String expr, String language);

  public native void setExpression(String name, String expr);

  public native void setProperty(String propertyName, String value, String priority);

  public native void setProperty(String propertyName, String value);

  @JsMethod(name = "getAttribute")
  public native String getAttributeAsString(String name, double flags);

  @JsMethod(name = "getAttribute")
  public native double getAttributeAsDouble(String name, double flags);

  @JsMethod(name = "getAttribute")
  public native boolean getAttributeAsBoolean(String name, double flags);

  @JsMethod(name = "getAttribute")
  public native String getAttributeAsString(String name);

  @JsMethod(name = "getAttribute")
  public native double getAttributeAsDouble(String name);

  @JsMethod(name = "getAttribute")
  public native boolean getAttributeAsBoolean(String name);

  @JsMethod(name = "getExpression")
  public native String getExpressionAsString(String name);

  @JsMethod(name = "getExpression")
  public native double getExpressionAsDouble(String name);

  @JsMethod(name = "getExpression")
  public native boolean getExpressionAsBoolean(String name);

}
