/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CSSProperties {
  public String alignContent;
  public String alignItems;
  public String alignSelf;
  public String azimuth;
  public String backfaceVisibility;
  public String background;
  public String backgroundAttachment;
  public String backgroundColor;
  public String backgroundImage;
  public String backgroundPosition;
  public String backgroundRepeat;
  public String backgroundSize;
  public String border;
  public String borderBottom;
  public String borderBottomColor;
  public /* String | double */ Object borderBottomLeftRadius;
  public /* String | double */ Object borderBottomRightRadius;
  public String borderBottomStyle;
  public /* String | double */ Object borderBottomWidth;
  public String borderCollapse;
  public String borderColor;
  public String borderImage;
  public /* String | double */ Object borderImageOutset;
  public String borderImageRepeat;
  public /* String | double */ Object borderImageSlice;
  public String borderImageSource;
  public /* String | double */ Object borderImageWidth;
  public String borderLeft;
  public String borderLeftColor;
  public String borderLeftStyle;
  public /* String | double */ Object borderLeftWidth;
  public /* String | double */ Object borderRadius;
  public String borderRight;
  public String borderRightColor;
  public String borderRightStyle;
  public /* String | double */ Object borderRightWidth;
  public String borderSpacing;
  public String borderStyle;
  public String borderTop;
  public String borderTopColor;
  public /* String | double */ Object borderTopLeftRadius;
  public /* String | double */ Object borderTopRightRadius;
  public String borderTopStyle;
  public /* String | double */ Object borderTopWidth;
  public /* String | double */ Object borderWidth;
  public String bottom;
  public String boxShadow;
  public String boxSizing;
  public String captionSide;
  public String clear;
  public String clip;
  public String color;
  public String content;
  public String counterIncrement;
  public String counterReset;
  public String cssFloat;
  public String cssText;
  public String cue;
  public String cueAfter;
  public String cueBefore;
  public String cursor;
  public String direction;
  public String display;
  public String elevation;
  public String emptyCells;
  public String flex;
  public String flexBasis;
  public String flexDirection;
  public String flexFlow;
  public double flexGrow;
  public double flexShrink;
  public String flexWrap;
  public String font;
  public String fontFamily;
  public /* String | double */ Object fontSize;
  public String fontSizeAdjust;
  public String fontStretch;
  public String fontStyle;
  public String fontVariant;
  public String fontWeight;
  public /* String | double */ Object height;
  public String justifyContent;
  public String left;
  public String letterSpacing;
  public /* String | double */ Object lineHeight;
  public String listStyle;
  public String listStyleImage;
  public String listStylePosition;
  public String listStyleType;
  public /* String | double */ Object margin;
  public /* String | double */ Object marginBottom;
  public /* String | double */ Object marginLeft;
  public /* String | double */ Object marginRight;
  public /* String | double */ Object marginTop;
  public String markerOffset;
  public String marks;
  public /* String | double */ Object maxHeight;
  public /* String | double */ Object maxWidth;
  public /* String | double */ Object minHeight;
  public /* String | double */ Object minWidth;
  public /* String | double */ Object opacity;
  public double order;
  public String orphans;
  public String outline;
  public String outlineColor;
  public String outlineStyle;
  public /* String | double */ Object outlineWidth;
  public String overflow;
  public /* String | double */ Object padding;
  public /* String | double */ Object paddingBottom;
  public /* String | double */ Object paddingLeft;
  public /* String | double */ Object paddingRight;
  public /* String | double */ Object paddingTop;
  public String page;
  public String pageBreakAfter;
  public String pageBreakBefore;
  public String pageBreakInside;
  public String pause;
  public String pauseAfter;
  public String pauseBefore;
  public String perspective;
  public /* String | double */ Object perspectiveOrigin;
  public String pitch;
  public String pitchRange;
  public String playDuring;
  public String pointerEvents;
  public String position;
  public String quotes;
  public String resize;
  public String richness;
  public String right;
  public String size;
  public String speak;
  public String speakHeader;
  public String speakNumeral;
  public String speakPunctuation;
  public String speechRate;
  public String stress;
  public String tableLayout;
  public String textAlign;
  public String textDecoration;
  public String textIndent;
  public String textOverflow;
  public String textShadow;
  public String textTransform;
  public String top;
  public String transform;
  public /* String | double */ Object transformOrigin;
  public String transformStyle;
  public String transition;
  public String transitionDelay;
  public String transitionDuration;
  public String transitionProperty;
  public String transitionTimingFunction;
  public String unicodeBidi;
  public String verticalAlign;
  public String visibility;
  public String voiceFamily;
  public String volume;
  public String whiteSpace;
  public String widows;
  public /* String | double */ Object width;
  public String wordSpacing;
  public String wordWrap;
  public /* String | double */ Object zIndex;
  
  
}
