/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import elemental2.ArrayBuffer;
import java.lang.String;
import elemental2.Blob;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class BlobBuilder {
  public native Object append(ArrayBuffer data, String endings);

  public native Object append(String data, String endings);

  public native Object append(Blob data, String endings);

  public native Object append(ArrayBuffer data);

  public native Object append(String data);

  public native Object append(Blob data);

  public native Blob getBlob(String contentType);

  public native Blob getBlob();

}
