/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;
import elemental2.NativeObject;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Blob {
  public double size;
  public String type;
  
  public Blob(/* ArrayBufferView | Blob | String */ Object[] blobParts, NativeObject options) {}

  public Blob() {}

  public Blob(/* ArrayBufferView | Blob | String */ Object[] blobParts) {}

  public native Blob mozSlice(double start, double end, String contentType);

  public native Blob mozSlice(double start, double end);

  public native Blob slice(double start, double length, String contentType);

  public native Blob slice(double start, double length);

  public native Blob webkitSlice(double start, double end, String contentType);

  public native Blob webkitSlice(double start, double end);

}
