/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import jsinterop.annotations.JsProperty;
import elemental2.BatteryManager.OnchargingchangeCallback;
import elemental2.BatteryManager.OnchargingtimechangeCallback;
import elemental2.BatteryManager.OndischargingtimechangeCallback;
import elemental2.BatteryManager.OnlevelchangeCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface BatteryManager extends EventTarget {
  @JsFunction
  public interface OnchargingchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnchargingtimechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndischargingtimechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnlevelchangeCallback {
    Object onInvoke(Event a);

  }
  @JsProperty
  void setCharging(boolean charging);

  @JsProperty
  boolean isCharging();

  @JsProperty
  void setChargingTime(double chargingTime);

  @JsProperty
  double getChargingTime();

  @JsProperty
  void setDischargingTime(double dischargingTime);

  @JsProperty
  double getDischargingTime();

  @JsProperty
  void setLevel(double level);

  @JsProperty
  double getLevel();

  @JsProperty
  void setOnchargingchange(OnchargingchangeCallback onchargingchange);

  @JsProperty
  OnchargingchangeCallback getOnchargingchange();

  @JsProperty
  void setOnchargingtimechange(OnchargingtimechangeCallback onchargingtimechange);

  @JsProperty
  OnchargingtimechangeCallback getOnchargingtimechange();

  @JsProperty
  void setOndischargingtimechange(OndischargingtimechangeCallback ondischargingtimechange);

  @JsProperty
  OndischargingtimechangeCallback getOndischargingtimechange();

  @JsProperty
  void setOnlevelchange(OnlevelchangeCallback onlevelchange);

  @JsProperty
  OnlevelchangeCallback getOnlevelchange();

}
