/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import elemental2.Float32Array;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioParam {
  public double defaultValue;
  public double maxValue;
  public double minValue;
  public double units;
  public double value;
  
  public native Object cancelScheduledValues(double startTime);

  public native Object exponentialRampToValueAtTime(double value, double endTime);

  public native Object linearRampToValueAtTime(double value, double endTime);

  public native Object setTargetAtTime(double target, double startTime, double timeConstant);

  public native Object setTargetValueAtTime(double target, double startTime, double timeConstant);

  public native Object setValueAtTime(double value, double startTime);

  public native Object setValueCurveAtTime(Float32Array values, double startTime, double duration);

}
