/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.AudioBuffer;
import elemental2.AudioDestinationNode;
import elemental2.AudioListener;
import elemental2.RealtimeAnalyserNode;
import elemental2.BiquadFilterNode;
import elemental2.AudioBufferSourceNode;
import elemental2.AudioChannelMerger;
import elemental2.AudioChannelSplitter;
import elemental2.ConvolverNode;
import elemental2.DelayNode;
import elemental2.DynamicsCompressorNode;
import elemental2.GainNode;
import elemental2.ScriptProcessorNode;
import elemental2.MediaElementAudioSourceNode;
import elemental2.HTMLMediaElement;
import elemental2.MediaStreamAudioDestinationNode;
import elemental2.MediaStreamAudioSourceNode;
import elemental2.MediaStream;
import elemental2.OscillatorNode;
import elemental2.AudioPannerNode;
import elemental2.PeriodicWave;
import elemental2.Float32Array;
import elemental2.StereoPannerNode;
import elemental2.WaveShaperNode;
import elemental2.Promise;
import elemental2.ArrayBuffer;
import elemental2.AudioContext.DecodeAudioDataSuccessCallback;
import elemental2.AudioContext.DecodeAudioDataErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioContext {
  @JsFunction
  public interface DecodeAudioDataSuccessCallback {
    Object onInvoke(AudioBuffer a);

  }
  @JsFunction
  public interface DecodeAudioDataErrorCallback {
    Object onInvoke(Object a);

  }
  public double currentTime;
  public AudioDestinationNode destination;
  public AudioListener listener;
  public double sampleRate;
  
  public native RealtimeAnalyserNode createAnalyser();

  public native BiquadFilterNode createBiquadFilter();

  public native AudioBuffer createBuffer(double numberOfChannels, double length, double sampleRate);

  public native AudioBufferSourceNode createBufferSource();

  public native AudioChannelMerger createChannelMerger(double numberOfInputs);

  public native AudioChannelMerger createChannelMerger();

  public native AudioChannelSplitter createChannelSplitter(double numberOfOutputs);

  public native AudioChannelSplitter createChannelSplitter();

  public native ConvolverNode createConvolver();

  public native DelayNode createDelay(double maxDelayTime);

  public native DelayNode createDelay();

  public native DelayNode createDelayNode(double maxDelayTime);

  public native DelayNode createDelayNode();

  public native DynamicsCompressorNode createDynamicsCompressor();

  public native GainNode createGain();

  public native GainNode createGainNode();

  public native ScriptProcessorNode createJavaScriptNode(double bufferSize, double numberOfInputs, double numberOfOuputs);

  public native MediaElementAudioSourceNode createMediaElementSource(HTMLMediaElement mediaElement);

  public native MediaStreamAudioDestinationNode createMediaStreamDestination();

  public native MediaStreamAudioSourceNode createMediaStreamSource(MediaStream mediaStream);

  public native OscillatorNode createOscillator();

  public native AudioPannerNode createPanner();

  public native PeriodicWave createPeriodicWave(Float32Array real, Float32Array imag);

  public native ScriptProcessorNode createScriptProcessor(double bufferSize, double numberOfInputChannels_opt, double numberOfOutputChannels_opt);

  public native ScriptProcessorNode createScriptProcessor(double bufferSize);

  public native ScriptProcessorNode createScriptProcessor(double bufferSize, double numberOfInputChannels_opt);

  public native StereoPannerNode createStereoPanner();

  public native WaveShaperNode createWaveShaper();

  public native Promise<AudioBuffer> decodeAudioData(ArrayBuffer audioData, DecodeAudioDataSuccessCallback successCallback, DecodeAudioDataErrorCallback errorCallback);

  public native Promise<AudioBuffer> decodeAudioData(ArrayBuffer audioData);

  public native Promise<AudioBuffer> decodeAudioData(ArrayBuffer audioData, DecodeAudioDataSuccessCallback successCallback);

}
