/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.AudioSourceNode;
import elemental2.AudioBuffer;
import elemental2.AudioParam;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioBufferSourceNode extends AudioSourceNode {
  public double FINISHED_STATE;
  public double PLAYING_STATE;
  public double SCHEDULED_STATE;
  public double UNSCHEDULED_STATE;
  public AudioBuffer buffer;
  public double gain;
  public boolean loop;
  public double loopEnd;
  public double loopStart;
  public AudioParam playbackRate;
  public double playbackState;
  
  public native Object noteGrainOn(double when, double grainOffset, double grainDuration);

  public native Object noteOff(double when);

  public native Object noteOn(double when);

  public native Object start(double when, double offset, double duration);

  public native Object start(double when);

  public native Object start(double when, double offset);

  public native Object stop(double when);

}
