/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.IArrayLike;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Array.EveryCallback;
import elemental2.Array.FilterCallback;
import elemental2.Array.ForEachCallback;
import elemental2.Iterator;
import elemental2.Array.FromOpt_mapFnCallback;
import java.lang.String;
import elemental2.Iterable;
import elemental2.Array.MapCallback;
import elemental2.Array.ObserveCallback;
import elemental2.Array.SomeCallback;
import elemental2.Array.UnobserveCallback;
import elemental2.Array.EveryCallback0;
import elemental2.Array.FilterCallback0;
import elemental2.Array.ForEachCallback0;
import elemental2.Array.FromOpt_mapFnCallback0;
import elemental2.Array.MapCallback0;
import elemental2.Array.ObserveCallback0;
import elemental2.Array.SomeCallback0;
import elemental2.Array.UnobserveCallback0;
import jsinterop.annotations.JsOverlay;
import jsinterop.helper.JsObjects;
import elemental2.Array.EveryCallback1;
import elemental2.Array.FilterCallback1;
import elemental2.Array.FindPredicateCallback;
import elemental2.Array.FindIndexPredicateCallback;
import elemental2.Array.ForEachCallback1;
import elemental2.IteratorIterable;
import java.lang.Double;
import elemental2.Array.MapCallback1;
import elemental2.Array.ReduceCallback;
import elemental2.Array.ReduceRightCallback;
import elemental2.Array.SomeCallback1;
import elemental2.Array.SortOpt_compareFunctionCallback;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Array<T> implements IArrayLike<T> {
  @JsFunction
  public interface EveryCallback<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface FilterCallback<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface ForEachCallback<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface FromOpt_mapFnCallback<R> {
    R onInvoke(/* String | T */ Object a, double b);

  }
  @JsFunction
  public interface MapCallback<T, R> {
    R onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface ObserveCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface SomeCallback<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface UnobserveCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface EveryCallback0<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface FilterCallback0<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface ForEachCallback0<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface FromOpt_mapFnCallback0<R> {
    R onInvoke(/* String | T */ Object a, double b);

  }
  @JsFunction
  public interface MapCallback0<T, R> {
    R onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface ObserveCallback0 {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface SomeCallback0<T> {
    Object onInvoke(T a, double b, Object c);

  }
  @JsFunction
  public interface UnobserveCallback0 {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface EveryCallback1<T> {
    Object onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface FilterCallback1<T> {
    Object onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface FindPredicateCallback<T> {
    boolean onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface FindIndexPredicateCallback<T> {
    boolean onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface ForEachCallback1<T> {
    Object onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface MapCallback1<T, R> {
    R onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface ReduceCallback<T, R> {
    R onInvoke(Object a, T b, double c, T[] d);

  }
  @JsFunction
  public interface ReduceRightCallback<T, R> {
    R onInvoke(Object a, T b, double c, T[] d);

  }
  @JsFunction
  public interface SomeCallback1<T> {
    Object onInvoke(T a, double b, T[] c);

  }
  @JsFunction
  public interface SortOpt_compareFunctionCallback<T> {
    double onInvoke(T a, T b);

  }
  public static native <T, S> boolean every(IArrayLike<T> arr, EveryCallback<T> callback, S context);

  public static native <T> boolean every(IArrayLike<T> arr, EveryCallback<T> callback);

  public static native <T, S> T[] filter(IArrayLike<T> arr, FilterCallback<T> callback, S context);

  public static native <T> T[] filter(IArrayLike<T> arr, FilterCallback<T> callback);

  public static native <T, S> Object forEach(IArrayLike<T> arr, ForEachCallback<T> callback, S context);

  public static native <T> Object forEach(IArrayLike<T> arr, ForEachCallback<T> callback);

  public static native <T, S, R> R[] from(Iterator<T> arrayLike, FromOpt_mapFnCallback<R> mapFn, S this_);

  public static native <S, R> R[] from(String arrayLike, FromOpt_mapFnCallback<R> mapFn, S this_);

  public static native <T, S, R> R[] from(IArrayLike<T> arrayLike, FromOpt_mapFnCallback<R> mapFn, S this_);

  public static native <T, S, R> R[] from(Iterable<T> arrayLike, FromOpt_mapFnCallback<R> mapFn, S this_);

  public static native <T, R> R[] from(Iterator<T> arrayLike);

  public static native <R> R[] from(String arrayLike);

  public static native <T, R> R[] from(IArrayLike<T> arrayLike);

  public static native <T, R> R[] from(Iterable<T> arrayLike);

  public static native <T, R> R[] from(Iterator<T> arrayLike, FromOpt_mapFnCallback<R> mapFn);

  public static native <R> R[] from(String arrayLike, FromOpt_mapFnCallback<R> mapFn);

  public static native <T, R> R[] from(IArrayLike<T> arrayLike, FromOpt_mapFnCallback<R> mapFn);

  public static native <T, R> R[] from(Iterable<T> arrayLike, FromOpt_mapFnCallback<R> mapFn);

  public static native <T> double indexOf(IArrayLike<T> arr, T obj, double fromIndex);

  public static native <T> double indexOf(IArrayLike<T> arr, T obj);

  public static native boolean isArray(Object arr);

  public static native <T> double lastIndexOf(IArrayLike<T> arr, T obj, double fromIndex);

  public static native <T> double lastIndexOf(IArrayLike<T> arr, T obj);

  public static native <T, S, R> R[] map(IArrayLike<T> arr, MapCallback<T, R> callback, S context);

  public static native <T, R> R[] map(IArrayLike<T> arr, MapCallback<T, R> callback);

  public static native Object observe(Object[] array, ObserveCallback callback);

  public static native <T> T[] of(T... var_args);

  public static native <T, S> boolean some(IArrayLike<T> arr, SomeCallback<T> callback, S context);

  public static native <T> boolean some(IArrayLike<T> arr, SomeCallback<T> callback);

  public static native Object unobserve(Object[] array, UnobserveCallback callback);

  public static native <T, S> boolean every(IArrayLike<T> arr, EveryCallback0<T> callback, S context);

  public static native <T> boolean every(IArrayLike<T> arr, EveryCallback0<T> callback);

  public static native <T, S> T[] filter(IArrayLike<T> arr, FilterCallback0<T> callback, S context);

  public static native <T> T[] filter(IArrayLike<T> arr, FilterCallback0<T> callback);

  public static native <T, S> Object forEach(IArrayLike<T> arr, ForEachCallback0<T> callback, S context);

  public static native <T> Object forEach(IArrayLike<T> arr, ForEachCallback0<T> callback);

  public static native <T, S, R> R[] from(Iterator<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn, S this_);

  public static native <S, R> R[] from(String arrayLike, FromOpt_mapFnCallback0<R> mapFn, S this_);

  public static native <T, S, R> R[] from(IArrayLike<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn, S this_);

  public static native <T, S, R> R[] from(Iterable<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn, S this_);

  public static native <T, R> R[] from(Iterator<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn);

  public static native <R> R[] from(String arrayLike, FromOpt_mapFnCallback0<R> mapFn);

  public static native <T, R> R[] from(IArrayLike<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn);

  public static native <T, R> R[] from(Iterable<T> arrayLike, FromOpt_mapFnCallback0<R> mapFn);

  public static native <T, S, R> R[] map(IArrayLike<T> arr, MapCallback0<T, R> callback, S context);

  public static native <T, R> R[] map(IArrayLike<T> arr, MapCallback0<T, R> callback);

  public static native Object observe(Object[] array, ObserveCallback0 callback);

  public static native <T, S> boolean some(IArrayLike<T> arr, SomeCallback0<T> callback, S context);

  public static native <T> boolean some(IArrayLike<T> arr, SomeCallback0<T> callback);

  public static native Object unobserve(Object[] array, UnobserveCallback0 callback);

  public double index;
  public String input;
  public double length;
  
  public Array(Object... var_args) {}

  @JsOverlay
  public final T get(double key){
    return JsObjects.get(this, key);
  }

  public native Object[] concat(Object... var_args);

  public native Object copyWithin(double target, double start, double end);

  public native Object copyWithin(double target, double start);

  public native Object entries();

  public native <S> boolean every(EveryCallback1<T> callback, S thisobj);

  public native boolean every(EveryCallback1<T> callback);

  public native IArrayLike<T> fill(T value, double begin, double end);

  public native IArrayLike<T> fill(T value);

  public native IArrayLike<T> fill(T value, double begin);

  public native <S> T[] filter(FilterCallback1<T> callback, S thisobj);

  public native T[] filter(FilterCallback1<T> callback);

  public native <S> T find(FindPredicateCallback<T> predicate, S this_);

  public native T find(FindPredicateCallback<T> predicate);

  public native <S> double findIndex(FindIndexPredicateCallback<T> predicate, S this_);

  public native double findIndex(FindIndexPredicateCallback<T> predicate);

  public native <S> Object forEach(ForEachCallback1<T> callback, S thisobj);

  public native Object forEach(ForEachCallback1<T> callback);

  public native boolean includes(T searchElement, double fromIndex);

  public native boolean includes(T searchElement);

  public native double indexOf(T obj, double fromIndex);

  public native double indexOf(T obj);

  public native String join(Object separator);

  public native String join();

  public native IteratorIterable<Double> keys();

  public native double lastIndexOf(T obj, double fromIndex);

  public native double lastIndexOf(T obj);

  public native <S, R> R[] map(MapCallback1<T, R> callback, S thisobj);

  public native <R> R[] map(MapCallback1<T, R> callback);

  public native T pop();

  public native double push(T... var_args);

  public native <R> R reduce(ReduceCallback<T, R> callback, Object initialValue);

  public native <R> R reduce(ReduceCallback<T, R> callback);

  public native <R> R reduceRight(ReduceRightCallback<T, R> callback, Object initialValue);

  public native <R> R reduceRight(ReduceRightCallback<T, R> callback);

  public native <THIS> THIS reverse();

  public native T shift();

  public native T[] slice(Object begin, Object end);

  public native T[] slice();

  public native T[] slice(Object begin);

  public native <S> boolean some(SomeCallback1<T> callback, S thisobj);

  public native boolean some(SomeCallback1<T> callback);

  public native Object sort(SortOpt_compareFunctionCallback<T> compareFunction);

  public native Object sort();

  public native T[] splice(Object index, Object howMany, T... var_args);

  public native T[] splice();

  public native T[] splice(Object index);

  public native String toSource();

  public native String toString();

  public native double unshift(Object... var_args);

  @JsMethod(name = "entries")
  public native IteratorIterable<Double[]> entriesAsDoubleArrayIteratorIterable();

  @JsMethod(name = "entries")
  public native IteratorIterable<T[]> entriesAsArrayIteratorIterable();

  @JsProperty
  public native void setLength(double length);

  @JsProperty
  public native double getLength();

}
