/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.IArrayLike;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Arguments.CalleeCallback;
import elemental2.Arguments.CallerCallback;
import jsinterop.annotations.JsOverlay;
import jsinterop.helper.JsObjects;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Arguments<T> implements IArrayLike<T> {
  @JsFunction
  public interface CalleeCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface CallerCallback {
    Object onInvoke(Object... a);

  }
  public CalleeCallback callee;
  public CallerCallback caller;
  public double length;
  
  @JsOverlay
  public final T get(double key){
    return JsObjects.get(this, key);
  }

  @JsProperty
  public native void setLength(double length);

  @JsProperty
  public native double getLength();

}
