/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class ListSetTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSet() {
        this.doTestSet(this.e3());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_null() {
        this.doTestSet(null);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_replacingNull() {
        Object[] elements = this.createSamplesArray();
        int i = this.aValidIndex();
        elements[i] = null;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements);
        this.doTestSet(this.e3());
    }

    private void doTestSet(E newValue) {
        int index = this.aValidIndex();
        Object initialValue = this.getList().get(index);
        ListSetTester.assertEquals((String)"set(i, x) should return the old element at position i.", initialValue, this.getList().set(index, newValue));
        ListSetTester.assertEquals((String)"After set(i, x), get(i) should return x", newValue, this.getList().get(index));
        ListSetTester.assertEquals((String)"set() should not change the size of a list.", (int)this.getNumElements(), (int)this.getList().size());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_indexTooLow() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().set(-1, this.e3()));
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_indexTooHigh() {
        int index = this.getNumElements();
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().set(index, this.e3()));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testSet_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getList().set(this.aValidIndex(), this.e3()));
        this.expectUnchanged();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testSet_unsupportedByEmptyList() {
        try {
            this.getList().set(0, this.e3());
            ListSetTester.fail((String)"set() should throw UnsupportedOperationException or IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSet_nullUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getList().set(this.aValidIndex(), null));
        this.expectUnchanged();
    }

    private int aValidIndex() {
        return this.getList().size() / 2;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSetNullSupportedMethod() {
        return Helpers.getMethod(ListSetTester.class, "testSet_null");
    }
}

