/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Beta
@GwtCompatible
public class TestLogHandler
extends Handler {
    private final List<LogRecord> list = new ArrayList<LogRecord>();

    @Override
    public synchronized void publish(@NullableDecl LogRecord record) {
        this.list.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized List<LogRecord> getStoredLogRecords() {
        ArrayList<LogRecord> result = new ArrayList<LogRecord>(this.list);
        return Collections.unmodifiableList(result);
    }
}

