/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.FileToFormat;
import com.google.googlejavaformat.java.FileToFormatPath;
import com.google.googlejavaformat.java.FileToFormatStdin;
import com.google.googlejavaformat.java.FormatFileCallable;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.UsageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class Main {
    private static final int MAX_THREADS = 20;
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final String[] VERSION = new String[]{"google-java-format: Version 1.0"};
    private static final String[] USAGE = (String[])ObjectArrays.concat((Object[])VERSION, (Object[])new String[]{"https://github.com/google/google-java-format"}, String.class);
    private static final String[] ADDITIONAL_USAGE = new String[]{"If -i is given with -, the result is sent to stdout.", "The --lines, --offset, and --length flags may be given more than once.", "The --offset and --length flags must be given an equal number of times.", "If --lines, --offset, or --length are given, only one file (or -) may be given."};
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final InputStream inStream;

    public Main(PrintWriter outWriter, PrintWriter errWriter, InputStream inStream) {
        this.outWriter = outWriter;
        this.errWriter = errWriter;
        this.inStream = inStream;
    }

    public static void main(String ... args) {
        Main formatter = new Main(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), true), new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8), true), System.in);
        try {
            int result = formatter.format(args);
            System.exit(result);
        }
        catch (UsageException e) {
            System.err.print(e.usage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int format(String ... args) throws UsageException {
        JavaFormatterOptions.SortImports sortImports;
        ArgInfo argInfo = ArgInfo.processArgs(args);
        if (argInfo.parameters.versionFlag) {
            this.version();
        }
        if (argInfo.parameters.helpFlag) {
            argInfo.throwUsage();
        }
        switch (argInfo.parameters.sortImportsFlag) {
            case "": {
                sortImports = JavaFormatterOptions.SortImports.NO;
                break;
            }
            case "only": {
                sortImports = JavaFormatterOptions.SortImports.ONLY;
                break;
            }
            case "also": {
                sortImports = JavaFormatterOptions.SortImports.ALSO;
                break;
            }
            default: {
                this.errWriter.println("Invalid value for --sort-imports. Should be \"only\" or \"also\".");
                return 1;
            }
        }
        if (sortImports != JavaFormatterOptions.SortImports.NO && argInfo.isSelection()) {
            this.errWriter.println("--sort-imports can currently only apply to the whole file");
            return 1;
        }
        ConstructFilesToFormatResult constructFilesToFormatResult = this.constructFilesToFormat(argInfo);
        boolean allOkay = constructFilesToFormatResult.allOkay;
        ImmutableList<FileToFormat> filesToFormat = constructFilesToFormatResult.filesToFormat;
        if (filesToFormat.isEmpty()) {
            return allOkay ? 0 : 1;
        }
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        int numThreads = Math.min(20, filesToFormat.size());
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        JavaFormatterOptions options = new JavaFormatterOptions(JavaFormatterOptions.JavadocFormatter.NONE, argInfo.parameters.aospFlag ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE, sortImports);
        Object outputLock = new Object();
        for (FileToFormat fileToFormat : filesToFormat) {
            results.add(executorService.submit(new FormatFileCallable(fileToFormat, outputLock, options, argInfo.parameters.iFlag, this.outWriter, this.errWriter)));
        }
        for (Future result : results) {
            Object object;
            try {
                allOkay &= ((Boolean)result.get()).booleanValue();
            }
            catch (InterruptedException e) {
                object = outputLock;
                synchronized (object) {
                    this.errWriter.println(e);
                }
                allOkay = false;
            }
            catch (ExecutionException e) {
                object = outputLock;
                synchronized (object) {
                    this.errWriter.println(e.getCause());
                }
                allOkay = false;
            }
        }
        return allOkay ? 0 : 1;
    }

    ConstructFilesToFormatResult constructFilesToFormat(ArgInfo argInfo) {
        boolean allOkay = true;
        HashSet<Path> seenRealPaths = new HashSet<Path>();
        ImmutableList.Builder filesToFormat = ImmutableList.builder();
        for (String fileName : argInfo.parameters.fileNamesFlag) {
            if (fileName.endsWith(".java")) {
                try {
                    Path originalPath = Paths.get(fileName, new String[0]);
                    boolean added = seenRealPaths.add(originalPath.toRealPath(new LinkOption[0]));
                    if (!added) continue;
                    filesToFormat.add((Object)new FileToFormatPath(originalPath, Main.parseRangeSet(argInfo.parameters.linesFlags), argInfo.parameters.offsetFlags, argInfo.parameters.lengthFlags));
                }
                catch (IOException e) {
                    this.errWriter.append(fileName).append(": could not read file: ").append(e.getMessage()).append('\n').flush();
                    allOkay = false;
                }
                continue;
            }
            this.errWriter.println("Skipping non-Java file: " + fileName);
        }
        if (argInfo.parameters.stdinStdoutFlag) {
            filesToFormat.add((Object)new FileToFormatStdin(Main.parseRangeSet(argInfo.parameters.linesFlags), argInfo.parameters.offsetFlags, argInfo.parameters.lengthFlags, this.inStream));
        }
        return new ConstructFilesToFormatResult(allOkay, (ImmutableList<FileToFormat>)filesToFormat.build());
    }

    private void version() {
        for (String line : VERSION) {
            this.errWriter.println(line);
        }
    }

    private static RangeSet<Integer> parseRangeSet(List<String> linesFlags) {
        TreeRangeSet result = TreeRangeSet.create();
        for (String linesFlag : linesFlags) {
            for (String range : COMMA_SPLITTER.split((CharSequence)linesFlag)) {
                result.add(Main.parseRange(range));
            }
        }
        return result;
    }

    private static Range<Integer> parseRange(String arg) {
        List args = COLON_SPLITTER.splitToList((CharSequence)arg);
        switch (args.size()) {
            case 1: {
                int line = Integer.parseInt((String)args.get(0)) - 1;
                return Range.closedOpen((Comparable)Integer.valueOf(line), (Comparable)Integer.valueOf(line + 1));
            }
            case 2: {
                int line0 = Integer.parseInt((String)args.get(0)) - 1;
                int line1 = Integer.parseInt((String)args.get(1)) - 1;
                return Range.closedOpen((Comparable)Integer.valueOf(line0), (Comparable)Integer.valueOf(line1 + 1));
            }
        }
        throw new IllegalArgumentException(arg);
    }

    static class ArgInfo {
        public final FormatterParameters parameters;
        private final JCommander jCommander;

        public static ArgInfo processArgs(String ... args) throws UsageException {
            FormatterParameters parameters = new FormatterParameters();
            JCommander jCommander = new JCommander((Object)parameters);
            ArgInfo argInfo = new ArgInfo(parameters, jCommander);
            jCommander.setProgramName("google-java-format");
            try {
                jCommander.parse(args);
            }
            catch (ParameterException ignored) {
                argInfo.throwUsage();
            }
            int filesToFormat = parameters.fileNamesFlag.size();
            if (parameters.stdinStdoutFlag) {
                ++filesToFormat;
            }
            if (parameters.iFlag && parameters.fileNamesFlag.isEmpty()) {
                argInfo.throwUsage();
            }
            if (argInfo.isSelection() && filesToFormat != 1) {
                argInfo.throwUsage();
            }
            if (parameters.offsetFlags.size() != parameters.lengthFlags.size()) {
                argInfo.throwUsage();
            }
            if (filesToFormat <= 0 && !parameters.versionFlag && !parameters.helpFlag) {
                argInfo.throwUsage();
            }
            return argInfo;
        }

        boolean isSelection() {
            return !this.parameters.linesFlags.isEmpty() || !this.parameters.offsetFlags.isEmpty() || !this.parameters.lengthFlags.isEmpty();
        }

        private ArgInfo(FormatterParameters parameters, JCommander jCommander) {
            this.parameters = parameters;
            this.jCommander = jCommander;
        }

        public void throwUsage() throws UsageException {
            StringBuilder builder = new StringBuilder();
            ArgInfo.addLines(builder, USAGE);
            this.jCommander.usage(builder);
            ArgInfo.addLines(builder, ADDITIONAL_USAGE);
            throw new UsageException(builder.toString());
        }

        private static void addLines(StringBuilder builder, String[] lines) {
            for (String line : lines) {
                builder.append(line);
                builder.append(System.lineSeparator());
            }
        }
    }

    static class ConstructFilesToFormatResult {
        final boolean allOkay;
        final ImmutableList<FileToFormat> filesToFormat;

        ConstructFilesToFormatResult(boolean allOkay, ImmutableList<FileToFormat> filesToFormat) {
            this.allOkay = allOkay;
            this.filesToFormat = filesToFormat;
        }
    }

    @Parameters(separators="=")
    private static final class FormatterParameters {
        @Parameter(names={"-i", "-r", "-replace", "--replace"}, description="Send formatted output back to files, not stdout.")
        boolean iFlag = false;
        @Parameter(names={"--lines", "-lines", "--line", "-line"}, description="Line range(s) to format, like 5:10 (1-based; default is all).")
        final List<String> linesFlags = new ArrayList<String>();
        @Parameter(names={"--offset", "-offset"}, description="Character offset to format (0-based; default is all).")
        private final List<Integer> offsetFlags = new ArrayList<Integer>();
        @Parameter(names={"--length", "-length"}, description="Character length to format.")
        private final List<Integer> lengthFlags = new ArrayList<Integer>();
        @Parameter(names={"--aosp", "-aosp", "-a"}, description="Use AOSP style instead of Google Style (4-space indentation).")
        boolean aospFlag = false;
        @Parameter(names={"--version", "-version", "-v"}, description="Print the version.")
        boolean versionFlag = false;
        @Parameter(names={"--help", "-help", "-h"}, description="Print an extended usage statement.")
        boolean helpFlag = false;
        @Parameter(names={"--sort-imports", "-sort-imports"}, description="Sort import statements. --sort-imports=only to sort imports but do no other formatting. --sort-imports=also to sort imports and do other formatting.", hidden=true)
        String sortImportsFlag = "";
        @Parameter(names={"-"}, description="Format stdin -> stdout.")
        boolean stdinStdoutFlag = false;
        @Parameter(description="file(s)")
        final List<String> fileNamesFlag = new ArrayList<String>();

        private FormatterParameters() {
        }
    }
}

