/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

@GwtIncompatible(value="Insufficient support for generics")
interface S2ShapeAspect {

    public static interface Mixed
    extends S2Shape,
    VertexAspect,
    EdgeAspect,
    ChainAspect,
    TopoAspect {
    }

    public static interface TopoAspect {
        public boolean hasInterior();

        public boolean containsOrigin();

        public int dimension();
    }

    public static interface ChainAspect {
        public int chainId(int var1);

        public int edgeId(int var1);

        public int numChains();

        public int getChainStart(int var1);

        public int getChainLength(int var1);

        public static abstract class Multi
        implements Mixed {
            private final int[] cumulativeEdges;

            public Multi(Iterable<? extends Iterable<?>> chains) {
                this.cumulativeEdges = new int[Iterables.size(chains) + 1];
                int sum = 0;
                int offset = 0;
                for (Iterable<?> chain : chains) {
                    this.cumulativeEdges[offset++] = sum;
                    sum += Iterables.size(chain);
                }
                this.cumulativeEdges[offset] = sum;
                this.adjustChains(this.cumulativeEdges);
            }

            Multi(int[] cumulativeEdges) {
                this.cumulativeEdges = cumulativeEdges;
                this.adjustChains(cumulativeEdges);
            }

            @Override
            public final int numChains() {
                return this.cumulativeEdges.length - 1;
            }

            @Override
            public final int edgeId(int chainId) {
                return this.cumulativeEdges[chainId];
            }

            @Override
            public final int getChainStart(int chainId) {
                Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
                return this.edgeId(chainId);
            }

            @Override
            public final int getChainLength(int chainId) {
                return this.edgeId(chainId + 1) - this.edgeId(chainId);
            }

            @Override
            public final int chainId(int edgeId) {
                int chainId = Arrays.binarySearch(this.cumulativeEdges, edgeId);
                if (chainId < 0) {
                    chainId = -chainId - 2;
                }
                while (this.getChainLength(chainId) == 0) {
                    ++chainId;
                }
                return chainId;
            }

            static abstract class Snapped
            extends Multi {
                private final long[] vertices;

                public Snapped(Iterable<? extends Iterable<S2CellId>> chains) {
                    super(chains);
                    this.vertices = Simple.Snapped.toArray(Iterables.concat(chains));
                }

                @Override
                public int numVertices() {
                    return this.vertices.length;
                }

                @Override
                public S2Point vertex(int index) {
                    return new S2CellId(this.vertices[index]).toPoint();
                }
            }

            static abstract class Packed
            extends Multi {
                private final double[] coordinates;

                public Packed(Iterable<? extends Iterable<S2Point>> chains) {
                    super(chains);
                    this.coordinates = Simple.Packed.toArray(Iterables.concat(chains));
                }

                @Override
                public int numVertices() {
                    return this.coordinates.length / 3;
                }

                @Override
                public S2Point vertex(int index) {
                    return Simple.Packed.vertex(this.coordinates, index);
                }
            }

            static abstract class Array
            extends Multi {
                private final S2Point[] vertices;

                Array(Iterable<? extends Iterable<S2Point>> chains) {
                    super(chains);
                    this.vertices = Simple.Array.toArray(Iterables.concat(chains));
                }

                @Override
                public int numVertices() {
                    return this.vertices.length;
                }

                @Override
                public S2Point vertex(int index) {
                    return this.vertices[index];
                }
            }
        }

        public static abstract class Simple
        implements Mixed {
            @Override
            public int numChains() {
                return 1;
            }

            @Override
            public int getChainStart(int chainId) {
                Preconditions.checkElementIndex((int)chainId, (int)1);
                return 0;
            }

            @Override
            public int getChainLength(int chainId) {
                Preconditions.checkElementIndex((int)chainId, (int)1);
                return this.numEdges();
            }

            @Override
            public int edgeId(int chainId) {
                switch (chainId) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return this.numEdges();
                    }
                }
                throw new IndexOutOfBoundsException("Invalid chain " + chainId);
            }

            @Override
            public int chainId(int edgeIndex) {
                Preconditions.checkElementIndex((int)edgeIndex, (int)this.numEdges());
                return 0;
            }

            static abstract class Snapped
            extends Simple {
                private final long[] vertices;

                public Snapped(Iterable<S2CellId> vertices) {
                    this.vertices = Snapped.toArray(vertices);
                }

                @Override
                public int numVertices() {
                    return this.vertices.length;
                }

                @Override
                public S2Point vertex(int index) {
                    return new S2CellId(this.vertices[index]).toPoint();
                }

                private static long[] toArray(Iterable<S2CellId> vertices) {
                    long[] ids = new long[Iterables.size(vertices)];
                    int offset = 0;
                    for (S2CellId vertex : vertices) {
                        ids[offset++] = vertex.id();
                    }
                    return ids;
                }
            }

            static abstract class Packed
            extends Simple {
                private final double[] coordinates;

                public Packed(Iterable<S2Point> vertices) {
                    this.coordinates = Packed.toArray(vertices);
                }

                @Override
                public int numVertices() {
                    return this.coordinates.length / 3;
                }

                @Override
                public S2Point vertex(int index) {
                    return Packed.vertex(this.coordinates, index);
                }

                private static double[] toArray(Iterable<S2Point> vertices) {
                    double[] coordinates = new double[3 * Iterables.size(vertices)];
                    int offset = 0;
                    for (S2Point v : vertices) {
                        coordinates[offset++] = v.x;
                        coordinates[offset++] = v.y;
                        coordinates[offset++] = v.z;
                    }
                    return coordinates;
                }

                private static S2Point vertex(double[] coordinates, int index) {
                    int offset = 3 * index;
                    return new S2Point(coordinates[offset], coordinates[offset + 1], coordinates[offset + 2]);
                }
            }

            static abstract class Array
            extends Simple {
                private final S2Point[] vertices;

                Array(Iterable<S2Point> vertices) {
                    this.vertices = Array.toArray(vertices);
                }

                @Override
                public int numVertices() {
                    return this.vertices.length;
                }

                @Override
                public S2Point vertex(int index) {
                    return this.vertices[index];
                }

                private static S2Point[] toArray(Iterable<S2Point> vertices) {
                    S2Point[] array = new S2Point[Iterables.size(vertices)];
                    int offset = 0;
                    for (S2Point v : vertices) {
                        array[offset++] = v;
                    }
                    return array;
                }
            }
        }
    }

    public static interface EdgeAspect {
        public int vertexId(int var1, int var2);

        public void adjustChains(int ... var1);

        public S2Point getChainVertex(int var1, int var2);

        public int numEdges();

        public void getEdge(int var1, S2Shape.MutableEdge var2);

        public void getChainEdge(int var1, int var2, S2Shape.MutableEdge var3);

        public static interface Open
        extends Mixed {
            @Override
            default public void adjustChains(int ... chainStarts) {
                Preconditions.checkArgument((chainStarts.length > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 chain.");
                int last = chainStarts[0];
                for (int i = 1; i < chainStarts.length; ++i) {
                    int offset = chainStarts[i];
                    int n = i;
                    chainStarts[n] = chainStarts[n] - i;
                    Preconditions.checkArgument((last != offset ? 1 : 0) != 0, (Object)"Must have at least 1 edge.");
                    last = offset;
                }
            }

            @Override
            default public int numEdges() {
                return this.numVertices() - this.numChains();
            }

            @Override
            default public void getEdge(int edgeId, S2Shape.MutableEdge result) {
                int vertexId = this.vertexId(this.chainId(edgeId), edgeId);
                result.set(this.vertex(vertexId), this.vertex(vertexId + 1));
            }

            @Override
            default public void getChainEdge(int chainId, int edgeOffset, S2Shape.MutableEdge result) {
                int vertexId = this.vertexId(chainId, this.getChainStart(chainId) + edgeOffset);
                result.set(this.vertex(vertexId), this.vertex(vertexId + 1));
            }

            @Override
            default public S2Point getChainVertex(int chainId, int edgeOffset) {
                return this.vertex(this.vertexId(chainId, this.getChainStart(chainId) + edgeOffset));
            }

            @Override
            default public int vertexId(int chainId, int edgeId) {
                return chainId + edgeId;
            }
        }

        public static interface Closed
        extends Mixed {
            @Override
            default public void adjustChains(int ... chainStarts) {
            }

            @Override
            default public int numEdges() {
                return this.numVertices();
            }

            @Override
            default public void getEdge(int edgeId, S2Shape.MutableEdge result) {
                result.set(this.vertex(edgeId), this.vertex(this.vertexId(this.chainId(edgeId), edgeId + 1)));
            }

            @Override
            default public void getChainEdge(int chainId, int edgeOffset, S2Shape.MutableEdge result) {
                int edgeId = this.getChainStart(chainId) + edgeOffset;
                result.set(this.vertex(edgeId), this.vertex(this.vertexId(chainId, edgeId + 1)));
            }

            @Override
            default public S2Point getChainVertex(int chainId, int edgeOffset) {
                return this.vertex(this.vertexId(chainId, this.getChainStart(chainId) + edgeOffset));
            }

            @Override
            default public int vertexId(int chainId, int edgeId) {
                return edgeId < this.edgeId(chainId + 1) ? edgeId : this.getChainStart(chainId);
            }
        }
    }

    public static interface VertexAspect {
        public int numVertices();

        public S2Point vertex(int var1);

        default public List<S2Point> vertices() {
            return new AbstractList<S2Point>(){

                @Override
                public int size() {
                    return this.numVertices();
                }

                @Override
                public S2Point get(int index) {
                    return this.vertex(index);
                }
            };
        }
    }
}

