/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Part;
import com.google.genai.types.Blob;
import com.google.genai.types.CodeExecutionResult;
import com.google.genai.types.ExecutableCode;
import com.google.genai.types.FileData;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.VideoMetadata;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Part
extends JsonSerializable {
    @JsonProperty(value="videoMetadata")
    public abstract Optional<VideoMetadata> videoMetadata();

    @JsonProperty(value="thought")
    public abstract Optional<Boolean> thought();

    @JsonProperty(value="codeExecutionResult")
    public abstract Optional<CodeExecutionResult> codeExecutionResult();

    @JsonProperty(value="executableCode")
    public abstract Optional<ExecutableCode> executableCode();

    @JsonProperty(value="fileData")
    public abstract Optional<FileData> fileData();

    @JsonProperty(value="functionCall")
    public abstract Optional<FunctionCall> functionCall();

    @JsonProperty(value="functionResponse")
    public abstract Optional<FunctionResponse> functionResponse();

    @JsonProperty(value="inlineData")
    public abstract Optional<Blob> inlineData();

    @JsonProperty(value="text")
    public abstract Optional<String> text();

    public static Builder builder() {
        return new AutoValue_Part.Builder();
    }

    public abstract Builder toBuilder();

    public static Part fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Part.class);
    }

    public static Part fromText(String text) {
        return Part.builder().text(text).build();
    }

    public static Part fromUri(String fileUri, String mimeType) {
        return Part.builder().fileData(FileData.builder().fileUri(fileUri).mimeType(mimeType).build()).build();
    }

    public static Part fromBytes(byte[] bytes, String mimeType) {
        return Part.builder().inlineData(Blob.builder().data(bytes).mimeType(mimeType).build()).build();
    }

    public static Part fromFunctionCall(String name, Map<String, Object> args) {
        return Part.builder().functionCall(FunctionCall.builder().name(name).args(args).build()).build();
    }

    public static Part fromFunctionResponse(String name, Map<String, Object> response) {
        return Part.builder().functionResponse(FunctionResponse.builder().name(name).response(response).build()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Part.Builder();
        }

        @JsonProperty(value="videoMetadata")
        public abstract Builder videoMetadata(VideoMetadata var1);

        @JsonProperty(value="thought")
        public abstract Builder thought(boolean var1);

        @JsonProperty(value="codeExecutionResult")
        public abstract Builder codeExecutionResult(CodeExecutionResult var1);

        @JsonProperty(value="executableCode")
        public abstract Builder executableCode(ExecutableCode var1);

        @JsonProperty(value="fileData")
        public abstract Builder fileData(FileData var1);

        @JsonProperty(value="functionCall")
        public abstract Builder functionCall(FunctionCall var1);

        @JsonProperty(value="functionResponse")
        public abstract Builder functionResponse(FunctionResponse var1);

        @JsonProperty(value="inlineData")
        public abstract Builder inlineData(Blob var1);

        @JsonProperty(value="text")
        public abstract Builder text(String var1);

        public abstract Part build();
    }
}

