/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.common.collect.ImmutableList;
import com.google.genai.ApiClient;
import com.google.genai.AsyncLive;
import com.google.genai.types.Blob;
import com.google.genai.types.LiveClientContent;
import com.google.genai.types.LiveClientMessage;
import com.google.genai.types.LiveClientRealtimeInput;
import com.google.genai.types.LiveClientToolResponse;
import com.google.genai.types.LiveSendClientContentParameters;
import com.google.genai.types.LiveSendRealtimeInputParameters;
import com.google.genai.types.LiveSendToolResponseParameters;
import com.google.genai.types.LiveServerMessage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class AsyncSession {
    private final ApiClient apiClient;
    private final AsyncLive.GenAiWebSocketClient websocket;

    AsyncSession(ApiClient apiClient, AsyncLive.GenAiWebSocketClient websocket) {
        this.apiClient = apiClient;
        this.websocket = websocket;
    }

    public CompletableFuture<Void> sendClientContent(LiveSendClientContentParameters clientContent) {
        return this.send(LiveClientMessage.builder().clientContent(LiveClientContent.fromJson(clientContent.toJson())).build());
    }

    public CompletableFuture<Void> sendRealtimeInput(LiveSendRealtimeInputParameters realtimeInput) {
        return this.send(LiveClientMessage.builder().realtimeInput(LiveClientRealtimeInput.builder().mediaChunks((List<Blob>)ImmutableList.of((Object)realtimeInput.media().orElse(Blob.builder().build()))).build()).build());
    }

    public CompletableFuture<Void> sendToolResponse(LiveSendToolResponseParameters toolResponse) {
        return this.send(LiveClientMessage.builder().toolResponse(LiveClientToolResponse.fromJson(toolResponse.toJson())).build());
    }

    private CompletableFuture<Void> send(LiveClientMessage input) {
        return CompletableFuture.runAsync(() -> this.websocket.send(input.toJson()));
    }

    public CompletableFuture<Void> receive(Consumer<LiveServerMessage> onMessage) {
        this.websocket.setMessageCallback(onMessage);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> this.websocket.close());
    }
}

