/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.genai.ApiClient;
import com.google.genai.AsyncSession;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.LiveClientSetup;
import com.google.genai.types.LiveConnectConfig;
import com.google.genai.types.LiveServerMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class AsyncLive {
    private final ApiClient apiClient;

    AsyncLive(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CompletableFuture<AsyncSession> connect(String model, LiveConnectConfig config) {
        CompletableFuture<AsyncSession> future = new CompletableFuture<AsyncSession>();
        GenAiWebSocketClient websocket = new GenAiWebSocketClient(this.getWebSocketUri(), this.getWebSocketHeaders(), this.getSetupRequest(model, config), future, this.apiClient);
        websocket.connect();
        return future;
    }

    private URI getWebSocketUri() {
        String baseUrl = this.apiClient.httpOptions.baseUrl().orElse(null);
        if (baseUrl == null) {
            throw new IllegalArgumentException("No base URL provided in the client.");
        }
        try {
            URI baseUri = new URI(baseUrl);
            String wsBaseUrl = new URI("wss", baseUri.getAuthority(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment()).toString();
            if (!this.apiClient.vertexAI()) {
                return new URI(String.format("%sws/google.ai.generativelanguage.%s.GenerativeService.BidiGenerateContent?key=%s", wsBaseUrl, this.apiClient.httpOptions.apiVersion().orElse("v1beta"), this.apiClient.apiKey()));
            }
            return new URI(String.format("%sws/google.cloud.aiplatform.%s.LlmBidiService/BidiGenerateContent", wsBaseUrl, this.apiClient.httpOptions.apiVersion().orElse("v1beta1")));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to parse URL.", e);
        }
    }

    private Map<String, String> getWebSocketHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.httpOptions.headers().ifPresent(headers::putAll);
        if (this.apiClient.vertexAI()) {
            try {
                GoogleCredentials credentials = this.apiClient.credentials.orElse(this.apiClient.defaultCredentials());
                credentials.refreshIfExpired();
                headers.put("Authorization", "Bearer " + credentials.getAccessToken().getTokenValue());
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials for Vertex AI.", e);
            }
        }
        return headers;
    }

    private String getSetupRequest(String model, LiveConnectConfig config) {
        LiveClientSetup.Builder setupBuilder = LiveClientSetup.builder();
        String transformedModel = Transformers.tModel(this.apiClient, model);
        if (this.apiClient.vertexAI() && transformedModel.startsWith("publishers/")) {
            transformedModel = String.format("projects/%s/locations/%s/%s", this.apiClient.project(), this.apiClient.location(), transformedModel);
        }
        setupBuilder.model(transformedModel);
        if (config == null) {
            return setupBuilder.build().toJson();
        }
        config.systemInstruction().ifPresent(setupBuilder::systemInstruction);
        config.tools().ifPresent(setupBuilder::tools);
        config.inputAudioTranscription().ifPresent(setupBuilder::inputAudioTranscription);
        config.outputAudioTranscription().ifPresent(setupBuilder::outputAudioTranscription);
        ObjectNode generationConfigNode = JsonSerializable.objectMapper.createObjectNode();
        if (config.temperature().isPresent()) {
            generationConfigNode.set("temperature", JsonSerializable.toJsonNode(config.temperature().get()));
        }
        if (config.topP().isPresent()) {
            generationConfigNode.set("topP", JsonSerializable.toJsonNode(config.topP().get()));
        }
        if (config.topK().isPresent()) {
            generationConfigNode.set("topK", JsonSerializable.toJsonNode(config.topK().get()).deepCopy());
        }
        if (config.maxOutputTokens().isPresent()) {
            generationConfigNode.set("maxOutputTokens", JsonSerializable.toJsonNode(config.maxOutputTokens().get()).deepCopy());
        }
        if (config.mediaResolution().isPresent()) {
            generationConfigNode.set("mediaResolution", JsonSerializable.toJsonNode(config.mediaResolution().get()).deepCopy());
        }
        if (config.seed().isPresent()) {
            generationConfigNode.set("seed", JsonSerializable.toJsonNode(config.seed().get()).deepCopy());
        }
        if (config.responseModalities().isPresent()) {
            generationConfigNode.set("responseModalities", JsonSerializable.toJsonNode(config.responseModalities().get()));
        }
        if (config.speechConfig().isPresent()) {
            generationConfigNode.set("speechConfig", JsonSerializable.toJsonNode(config.speechConfig().get()));
        }
        ObjectNode setupNode = (ObjectNode)JsonSerializable.toJsonNode(setupBuilder.build()).deepCopy();
        if (!generationConfigNode.isEmpty()) {
            setupNode.set("generationConfig", (JsonNode)generationConfigNode);
        }
        return String.format("{'setup':%s}", JsonSerializable.toJsonString(setupNode));
    }

    static class GenAiWebSocketClient
    extends WebSocketClient {
        private final String setupRequest;
        private final CompletableFuture<AsyncSession> sessionFuture;
        private final ApiClient apiClient;
        private Consumer<LiveServerMessage> messageCallback;

        public GenAiWebSocketClient(URI uri, Map<String, String> headers, String setupRequest, CompletableFuture<AsyncSession> sessionFuture, ApiClient apiClient) {
            super(uri, headers);
            this.setupRequest = setupRequest;
            this.sessionFuture = sessionFuture;
            this.messageCallback = null;
            this.apiClient = apiClient;
        }

        public void setMessageCallback(Consumer<LiveServerMessage> messageCallback) {
            this.messageCallback = messageCallback;
        }

        public void onOpen(ServerHandshake handshake) {
            this.send(this.setupRequest);
        }

        public void onMessage(String message) {
            this.handleIncomingMessage(message);
        }

        public void onMessage(ByteBuffer message) {
            try {
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                CharBuffer charBuffer = decoder.decode(message);
                this.handleIncomingMessage(charBuffer.toString());
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException("Invalid UTF-8 message received from the live session.", e);
            }
        }

        public void onError(Exception ex) {
            System.err.println("Error during live session: " + ex.getMessage());
            ex.printStackTrace();
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.completeExceptionally(ex);
            }
        }

        public void onClose(int code, String reason, boolean remote) {
            System.out.println("Live session closed with code: " + code + " and reason: " + reason);
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.completeExceptionally(new GenAiIOException("WebSocket closed unexpectedly: " + reason));
            }
        }

        private void handleIncomingMessage(String message) {
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.complete(new AsyncSession(this.apiClient, this));
                return;
            }
            if (this.messageCallback != null) {
                try {
                    LiveServerMessage serverMessage = LiveServerMessage.fromJson(message);
                    this.messageCallback.accept(serverMessage);
                }
                catch (RuntimeException e) {
                    System.err.println("Error deserializing message: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("Received message from live session but no callback registered! Please call `AsyncSession.receive()` to register a callback.");
            }
        }
    }
}

