/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.DateTimeValueConstruct;
import com.google.gdata.data.webmastertools.IntValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapsEntry<E extends SitemapsEntry<E>>
extends BaseEntry<E> {
    private static final String SITEMAP_STATUS = "sitemap-status";
    private static final String SITEMAP_DOWNLOADED = "sitemap-last-downloaded";
    private static final String SITEMAP_URL_COUNT = "sitemap-url-count";

    public SitemapsEntry() {
    }

    public SitemapsEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(SitemapsEntry.class, ExtensionDescription.getDefaultDescription(SitemapStatus.class));
        extProfile.declare(SitemapsEntry.class, ExtensionDescription.getDefaultDescription(LastDownloaded.class));
        extProfile.declare(SitemapsEntry.class, ExtensionDescription.getDefaultDescription(UrlCount.class));
        extProfile.setAutoExtending(true);
    }

    public void setSitemapStatus(String value) {
        SitemapStatus status = this.getExtension(SitemapStatus.class);
        if (status == null) {
            status = new SitemapStatus();
            this.setExtension(status);
        }
        status.setValue(value);
    }

    public String getSitemapStatus() {
        SitemapStatus status = this.getExtension(SitemapStatus.class);
        if (status == null) {
            return null;
        }
        return status.getValue();
    }

    public void setSitemapDownloadTime(DateTime value) {
        LastDownloaded time = this.getExtension(LastDownloaded.class);
        if (time == null) {
            time = new LastDownloaded();
            this.setExtension(time);
        }
        time.setDateTime(value);
    }

    public DateTime getSitemapDownloadTime() {
        LastDownloaded time = this.getExtension(LastDownloaded.class);
        if (time == null) {
            return null;
        }
        return time.getDateTime();
    }

    public void setSitemapUrlCount(int value) {
        UrlCount count = this.getExtension(UrlCount.class);
        if (count == null) {
            count = new UrlCount();
            this.setExtension(count);
        }
        count.setIntValue(value);
    }

    public int getSitemapUrlCount() {
        UrlCount count = this.getExtension(UrlCount.class);
        if (count == null) {
            return 0;
        }
        return count.getIntValue();
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-url-count")
    public static class UrlCount
    extends IntValueConstruct {
        public UrlCount() {
            super(SitemapsEntry.SITEMAP_URL_COUNT);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-last-downloaded")
    public static class LastDownloaded
    extends DateTimeValueConstruct {
        public LastDownloaded() {
            super(SitemapsEntry.SITEMAP_DOWNLOADED);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-status")
    public static class SitemapStatus
    extends ValueConstruct {
        public SitemapStatus() {
            super(Namespaces.WT_NAMESPACE, SitemapsEntry.SITEMAP_STATUS, null);
        }
    }
}

