/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="rating")
public class YtRating
extends AbstractExtension {
    private static final String NUM_LIKES = "numLikes";
    private static final String NUM_DISLIKES = "numDislikes";
    private static final String VALUE = "value";
    private int numLikes;
    private int numDislikes;
    private String value;

    public YtRating() {
    }

    public YtRating(int numLikes, int numDislikes) {
        this.numLikes = numLikes;
        this.numDislikes = numDislikes;
    }

    public YtRating(String value) {
        this.value = value;
    }

    public int getNumLikes() {
        return this.numLikes;
    }

    public void setNumLikes(int numLikes) {
        this.numLikes = numLikes;
    }

    public int getNumDislikes() {
        return this.numDislikes;
    }

    public void setNumDislikes(int numDislikes) {
        this.numDislikes = numDislikes;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        this.numLikes = helper.consumeInteger(NUM_LIKES, false);
        this.numDislikes = helper.consumeInteger(NUM_DISLIKES, false);
        this.value = helper.consume(VALUE, false);
    }

    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.numLikes > 0) {
            generator.put(NUM_LIKES, this.numLikes);
        }
        if (this.numDislikes > 0) {
            generator.put(NUM_DISLIKES, this.numDislikes);
        }
        if (this.value != null) {
            generator.put(VALUE, this.value);
        }
    }

    public static final class Value {
        public static final String DISLIKE = "dislike";
        public static final String LIKE = "like";
        private static final String[] ALL_VALUES = new String[]{"dislike", "like"};

        public static String[] values() {
            return ALL_VALUES;
        }

        private Value() {
        }
    }
}

