/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoWeight;
import com.google.gdata.data.photos.TagData;
import com.google.gdata.util.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/photos/2007#tag")
public class TagEntry
extends GphotoEntry<TagEntry>
implements AtomData,
TagData {
    public static final String KIND = "http://schemas.google.com/photos/2007#tag";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#tag");

    public TagEntry() {
        this.getCategories().add(CATEGORY);
    }

    public TagEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(TagEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(TagEntry.class, GphotoWeight.class);
    }

    public GphotoWeight getWeightExt() {
        return this.getExtension(GphotoWeight.class);
    }

    public void setWeightExt(GphotoWeight weightExt) {
        if (weightExt == null) {
            this.removeExtension(GphotoWeight.class);
        } else {
            this.setExtension(weightExt);
        }
    }

    public boolean hasWeightExt() {
        return this.hasExtension(GphotoWeight.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{TagEntry " + super.toString() + "}";
    }

    @Override
    public Integer getWeight() throws ParseException {
        GphotoWeight ext = this.getWeightExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setWeight(Integer weight) {
        GphotoWeight ext = weight == null ? null : new GphotoWeight(weight);
        this.setWeightExt(ext);
    }
}

