/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.data.IEntry;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;

public class MediaBodyPart
extends MimeBodyPart {
    private MediaSource mediaSource;

    public MediaBodyPart() {
    }

    public MediaBodyPart(InputStream is) throws MessagingException {
        super(new InternetHeaders(is), null);
        this.mediaSource = new MediaStreamSource(is, this.getContentType());
        this.initMediaDataHandler();
    }

    public MediaBodyPart(IEntry entry) throws MessagingException {
        this.setContent(entry, "application/atom+xml");
        this.setHeader("Content-Type", "application/atom+xml");
    }

    public MediaBodyPart(MediaSource mediaSource) throws MessagingException {
        this.mediaSource = mediaSource;
        this.setHeader("Content-Type", mediaSource.getContentType());
        String etag = mediaSource.getEtag();
        if (etag != null) {
            this.setHeader("ETag", etag);
        }
        this.initMediaDataHandler();
    }

    public MediaBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        super(headers, content);
        String contentType = this.getContentType();
        MediaStreamSource mediaStreamSource = new MediaStreamSource(new ByteArrayInputStream(content), contentType);
        String etag = this.getHeader("ETag", null);
        if (etag != null) {
            mediaStreamSource.setEtag(etag);
        }
        this.mediaSource = mediaStreamSource;
        this.initMediaDataHandler();
    }

    private void initMediaDataHandler() throws MessagingException {
        this.dh = !this.isAtomPart() ? new MediaSourceDataHandler(this.mediaSource) : new DataHandler((DataSource)this.mediaSource);
    }

    public boolean isAtomPart() throws MessagingException {
        return this.isMimeType("application/atom+xml");
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    private static class MediaSourceDataHandler
    extends DataHandler {
        MediaSource source;

        private MediaSourceDataHandler(MediaSource ds) {
            super((DataSource)ds);
            this.source = ds;
        }

        public Object getContent() {
            return this.source;
        }

        public void writeTo(OutputStream os) throws IOException {
            MediaSource.Output.writeTo(this.source, os);
        }
    }
}

