/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="ga", nsUri="http://schemas.google.com/ga/2009", localName="engagement")
public class Engagement
extends ExtensionPoint {
    static final String XML_NAME = "engagement";
    private static final String COMPARISON = "comparison";
    private static final String THRESHOLDVALUE = "thresholdValue";
    private static final String TYPE = "type";
    private String comparison = null;
    private Long thresholdValue = null;
    private String type = null;

    public Engagement() {
    }

    public Engagement(String comparison, Long thresholdValue, String type) {
        this.setComparison(comparison);
        this.setThresholdValue(thresholdValue);
        this.setType(type);
        this.setImmutable(true);
    }

    public String getComparison() {
        return this.comparison;
    }

    public void setComparison(String comparison) {
        this.throwExceptionIfImmutable();
        this.comparison = comparison;
    }

    public boolean hasComparison() {
        return this.getComparison() != null;
    }

    public Long getThresholdValue() {
        return this.thresholdValue;
    }

    public void setThresholdValue(Long thresholdValue) {
        this.throwExceptionIfImmutable();
        this.thresholdValue = thresholdValue;
    }

    public boolean hasThresholdValue() {
        return this.getThresholdValue() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    protected void validate() {
        if (this.comparison == null) {
            Engagement.throwExceptionForMissingAttribute(COMPARISON);
        }
        if (this.thresholdValue == null) {
            Engagement.throwExceptionForMissingAttribute(THRESHOLDVALUE);
        }
        if (this.type == null) {
            Engagement.throwExceptionForMissingAttribute(TYPE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Engagement.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(COMPARISON, this.comparison);
        generator.put(THRESHOLDVALUE, this.thresholdValue);
        generator.put(TYPE, this.type);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.comparison = helper.consume(COMPARISON, true);
        this.thresholdValue = helper.consumeLong(THRESHOLDVALUE, true);
        this.type = helper.consume(TYPE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Engagement other = (Engagement)obj;
        return Engagement.eq(this.comparison, other.comparison) && Engagement.eq(this.thresholdValue, other.thresholdValue) && Engagement.eq(this.type, other.type);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.comparison != null) {
            result = 37 * result + this.comparison.hashCode();
        }
        if (this.thresholdValue != null) {
            result = 37 * result + this.thresholdValue.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Engagement comparison=" + this.comparison + " thresholdValue=" + this.thresholdValue + " type=" + this.type + "}";
    }

    public static final class Type {
        public static final String PAGES_VISITED = "pagesVisited";
        public static final String TIME_ON_SITE = "timeOnSite";
    }

    public static final class Comparison {
        public static final String EQ = "=";
        public static final String GT = ">";
        public static final String LT = "<";
    }
}

