/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import android.support.annotation.NonNull;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.slf4j.Logger;

public class FirebasePerfTransform
extends Transform {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final Project project;
    private final AppExtension androidExt;
    private final Set<QualifiedContent.ContentType> typeClasses;
    private final Set<QualifiedContent.Scope> scopes;
    private Instrument firebasePerfInstrumentation;
    private final Map<String, Boolean> variantsToInstrumentationEnabled = new HashMap<String, Boolean>();
    private boolean instrumentationEnabled = true;
    private boolean applyToVariantUsed = false;

    public FirebasePerfTransform(Project project) {
        this.project = project;
        this.androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        this.typeClasses = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
        this.scopes = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS);
    }

    @NonNull
    public String getName() {
        return "FirebasePerformancePlugin";
    }

    @NonNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.typeClasses;
    }

    @NonNull
    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean applyToVariant(VariantInfo variant) {
        this.applyToVariantUsed = true;
        boolean enabled = this.instrumentationEnabledFor(variant.getFullVariantName(), variant.getBuildTypeName(), (List<String>)variant.getFlavorNames());
        logger.info(String.format("applyToVariant(%s): %s", variant, enabled));
        return enabled;
    }

    @NonNull
    public Map<String, Object> getParameterInputs() {
        if (!this.applyToVariantUsed) {
            this.androidExt.getApplicationVariants().all(this::updateInstrumentationEnabledFor);
        }
        return ImmutableMap.copyOf(this.variantsToInstrumentationEnabled);
    }

    private void updateInstrumentationEnabledFor(ApplicationVariant applicationVariant) {
        String variant = applicationVariant.getName();
        ArrayList<String> productFlavors = new ArrayList<String>();
        for (ProductFlavor flavor : applicationVariant.getProductFlavors()) {
            productFlavors.add(flavor.getName());
        }
        this.variantsToInstrumentationEnabled.put(variant, this.instrumentationEnabledFor(variant, applicationVariant.getBuildType().getName(), productFlavors));
    }

    private boolean instrumentationEnabledFor(String variant, String buildType, List<String> flavors) {
        Optional<Boolean> parsedPropVal = this.getProjectPropertyExtensionValue();
        if (parsedPropVal.isPresent()) {
            logger.info(String.format("Firebase Performance Instrumentation is %s per the Project Property specified in the 'gradle.properties' file.", parsedPropVal.get() != false ? "enabled" : "disabled"));
            return parsedPropVal.get();
        }
        Optional<Boolean> parsedBuildTypeVal = this.getBuildTypeExtensionValue(buildType);
        if (parsedBuildTypeVal.isPresent()) {
            logger.info(String.format(" Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for buildType=%s) in the 'build.gradle' file.", parsedBuildTypeVal.get() != false ? "enabled" : "disabled", variant, buildType));
            return parsedBuildTypeVal.get();
        }
        Optional<Boolean> parsedFlavorsVal = this.getProductFlavorsExtensionValue(flavors);
        if (parsedFlavorsVal.isPresent()) {
            logger.info(String.format(" Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for flavors=%s) in the 'build.gradle' file.", parsedFlavorsVal.get() != false ? "enabled" : "disabled", variant, flavors));
            return parsedFlavorsVal.get();
        }
        logger.info(String.format("Firebase Performance Instrumentation is %s by default for %s variant.", this.instrumentationEnabled ? "enabled" : "disabled", variant));
        return this.instrumentationEnabled;
    }

    private Optional<Boolean> getProjectPropertyExtensionValue() {
        return FirebasePerfPlugin.getProjectPropertyValue(this.project);
    }

    private Optional<Boolean> getBuildTypeExtensionValue(String buildType) {
        BuildType dslBuildType = (BuildType)this.androidExt.getBuildTypes().getByName(buildType);
        FirebasePerfExtension buildTypeExt = (FirebasePerfExtension)((ExtensionAware)dslBuildType).getExtensions().getByType(FirebasePerfExtension.class);
        return buildTypeExt != null ? buildTypeExt.isInstrumentationEnabled() : Optional.empty();
    }

    private Optional<Boolean> getProductFlavorsExtensionValue(List<String> flavors) {
        for (String flavor : flavors) {
            com.android.build.gradle.internal.dsl.ProductFlavor dslFlavor = (com.android.build.gradle.internal.dsl.ProductFlavor)this.androidExt.getProductFlavors().getByName(flavor);
            FirebasePerfExtension flavorExt = (FirebasePerfExtension)((ExtensionAware)dslFlavor).getExtensions().getByType(FirebasePerfExtension.class);
            if (flavorExt == null || !flavorExt.isInstrumentationEnabled().isPresent()) continue;
            return flavorExt.isInstrumentationEnabled();
        }
        return Optional.empty();
    }

    public void transform(TransformInvocation invocation) throws IOException {
        Collection transformInputs = invocation.getInputs();
        Collection referencedInputs = invocation.getReferencedInputs();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        boolean incremental = invocation.isIncremental();
        String variantName = invocation.getContext().getVariantName();
        this.instrumentationEnabled = this.applyToVariantUsed || this.variantsToInstrumentationEnabled.getOrDefault(variantName, this.instrumentationEnabled) != false;
        logger.info("Executing transform for buildVariant: {}; instrumentationEnabled: {}, applyToVariantUsed: {}", new Object[]{invocation.getContext().getVariantName(), this.instrumentationEnabled, this.applyToVariantUsed});
        List<URL> runtimeCP = this.buildRuntimeClasspath(transformInputs, referencedInputs);
        logger.debug("Effective app classpath at runtime:");
        for (URL url : runtimeCP) {
            logger.debug("- " + url);
        }
        try (URLClassLoader cl = new URLClassLoader(runtimeCP.toArray(new URL[0]));){
            logger.info("Transforming with incremental: {}", (Object)incremental);
            if (!incremental) {
                outputProvider.deleteAll();
            }
            this.firebasePerfInstrumentation = new Instrument(cl);
            for (TransformInput transformInput : transformInputs) {
                this.transformDirectoryInputs(transformInput, outputProvider, incremental);
                this.transformJarInputs(transformInput, outputProvider, incremental);
            }
        }
    }

    private void transformDirectoryInputs(TransformInput transformInput, TransformOutputProvider outputProvider, boolean incremental) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            File inputDir = directoryInput.getFile();
            File outputDir = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
            logger.debug("transformDirectoryInputs() >> inputDir: '{}', outputDir: '{}'", (Object)inputDir, (Object)outputDir);
            if (this.instrumentationEnabled) {
                this.performTransformationForDirectoryInput(directoryInput, inputDir, outputDir, incremental);
                continue;
            }
            this.performDummyTransformationForDirectoryInput(inputDir, outputDir);
        }
    }

    private void performTransformationForDirectoryInput(DirectoryInput directoryInput, File inputDir, File outputDir, boolean incremental) throws IOException {
        if (incremental) {
            for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                File inputFile = (File)entry.getKey();
                Status incrementalStatus = (Status)entry.getValue();
                logger.debug("performTransformationForDirectoryInput() >> inputFile: '{}', incrementalStatus: {}", (Object)inputFile, (Object)incrementalStatus);
                switch (incrementalStatus) {
                    case NOTCHANGED: {
                        break;
                    }
                    case ADDED: 
                    case CHANGED: {
                        this.transformFile(inputFile, inputDir, outputDir);
                        break;
                    }
                    case REMOVED: {
                        File outputFile = FirebasePerfTransform.toOutputFile(outputDir, inputDir, inputFile);
                        FileUtils.deleteIfExists((File)outputFile);
                    }
                }
            }
        } else {
            for (File inputFile : FileUtils.getAllFiles((File)inputDir)) {
                this.transformFile(inputFile, inputDir, outputDir);
            }
        }
    }

    private void transformFile(File inputFile, File inputDir, File outputDir) throws IOException {
        if (!inputFile.isDirectory() && inputFile.getName().endsWith(".class")) {
            File outputFile = FirebasePerfTransform.toOutputFile(outputDir, inputDir, inputFile);
            Files.createParentDirs((File)outputFile);
            this.firebasePerfInstrumentation.instrumentClassFile(inputFile, outputFile);
        }
    }

    private void performDummyTransformationForDirectoryInput(File inputDir, File outputDir) throws IOException {
        if (outputDir.mkdirs() || outputDir.isDirectory()) {
            org.apache.commons.io.FileUtils.deleteDirectory((File)outputDir);
            FileUtils.copyDirectory((File)inputDir, (File)outputDir);
        }
    }

    private void transformJarInputs(TransformInput transformInput, TransformOutputProvider outputProvider, boolean incremental) throws IOException {
        for (JarInput jarInput : transformInput.getJarInputs()) {
            File inputJar = jarInput.getFile();
            File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
            logger.debug("transformJarInputs() >> inputJar: '{}', outputJar: '{}'", (Object)inputJar, (Object)outputJar);
            if (this.instrumentationEnabled) {
                this.performTransformationForJarInput(jarInput, inputJar, outputJar, incremental);
                continue;
            }
            this.performDummyTransformationForJarInput(inputJar, outputJar);
        }
    }

    private void performTransformationForJarInput(JarInput jarInput, File inputJar, File outputJar, boolean incremental) throws IOException {
        if (incremental) {
            Status incrementalStatus = jarInput.getStatus();
            logger.debug("performTransformationForJarInput() >> inputJar: '{}', incrementalStatus: {}", (Object)inputJar, (Object)incrementalStatus);
            switch (incrementalStatus) {
                case NOTCHANGED: {
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    this.transformJar(inputJar, outputJar);
                    break;
                }
                case REMOVED: {
                    FileUtils.deleteIfExists((File)outputJar);
                }
            }
        } else {
            this.transformJar(inputJar, outputJar);
        }
    }

    private void transformJar(File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        this.firebasePerfInstrumentation.instrumentClassesInJar(inputJar, outputJar);
    }

    private void performDummyTransformationForJarInput(File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        try (FileInputStream fis = new FileInputStream(inputJar);
             FileOutputStream fos = new FileOutputStream(outputJar);){
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
        }
    }

    private static File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
    }

    private List<URL> buildRuntimeClasspath(Collection<TransformInput> transformInputs, Collection<TransformInput> referencedInputs) {
        ArrayList<File> classPaths = new ArrayList<File>(this.androidExt.getBootClasspath());
        for (Collection transformInputCollection : Arrays.asList(transformInputs, referencedInputs)) {
            for (TransformInput transformInput : transformInputCollection) {
                List<Collection> allQualifiedContents = Arrays.asList(transformInput.getDirectoryInputs(), transformInput.getJarInputs());
                for (Collection qualifiedContentCollection : allQualifiedContents) {
                    for (QualifiedContent qualifiedContent : qualifiedContentCollection) {
                        classPaths.add(qualifiedContent.getFile());
                    }
                }
            }
        }
        return classPaths.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error("Unable to instrument classes due to file '{}'", file);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

