/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.storage.internal.Sleeper;
import com.google.firebase.storage.internal.SleeperImpl;
import com.google.firebase.storage.internal.Util;
import com.google.firebase.storage.network.NetworkRequest;
import java.util.Random;

public class ExponentialBackoffSender {
    private static final String TAG = "ExponenentialBackoff";
    public static final int RND_MAX = 250;
    private static final int NETWORK_STATUS_POLL_INTERVAL = 1000;
    private static final int MAXIMUM_WAIT_TIME_MILLI = 30000;
    private static final Random random = new Random();
    static Sleeper sleeper = new SleeperImpl();
    static Clock clock = DefaultClock.getInstance();
    private final Context context;
    @Nullable
    private final InternalAuthProvider authProvider;
    @Nullable
    private final InternalAppCheckTokenProvider appCheckProvider;
    private long retryTime;
    private volatile boolean canceled;

    public ExponentialBackoffSender(Context context, @Nullable InternalAuthProvider authProvider, @Nullable InternalAppCheckTokenProvider appCheckProvider, long retryTime) {
        this.context = context;
        this.authProvider = authProvider;
        this.appCheckProvider = appCheckProvider;
        this.retryTime = retryTime;
    }

    public boolean isRetryableError(int resultCode) {
        return resultCode >= 500 && resultCode < 600 || resultCode == -2 || resultCode == 429 || resultCode == 408;
    }

    public void sendWithExponentialBackoff(@NonNull NetworkRequest request) {
        this.sendWithExponentialBackoff(request, true);
    }

    public void sendWithExponentialBackoff(@NonNull NetworkRequest request, boolean closeRequest) {
        Preconditions.checkNotNull((Object)request);
        long deadLine = clock.elapsedRealtime() + this.retryTime;
        if (closeRequest) {
            request.performRequest(Util.getCurrentAuthToken(this.authProvider), Util.getCurrentAppCheckToken(this.appCheckProvider), this.context);
        } else {
            request.performRequestStart(Util.getCurrentAuthToken(this.authProvider), Util.getCurrentAppCheckToken(this.appCheckProvider));
        }
        int currentSleepTime = 1000;
        while (clock.elapsedRealtime() + (long)currentSleepTime <= deadLine && !request.isResultSuccess() && this.isRetryableError(request.getResultCode())) {
            try {
                sleeper.sleep(currentSleepTime + random.nextInt(250));
            }
            catch (InterruptedException e) {
                Log.w((String)TAG, (String)"thread interrupted during exponential backoff.");
                Thread.currentThread().interrupt();
                return;
            }
            if (currentSleepTime < 30000) {
                if (request.getResultCode() != -2) {
                    currentSleepTime *= 2;
                    Log.w((String)TAG, (String)"network error occurred, backing off/sleeping.");
                } else {
                    currentSleepTime = 1000;
                    Log.w((String)TAG, (String)"network unavailable, sleeping.");
                }
            }
            if (this.canceled) {
                return;
            }
            request.reset();
            if (closeRequest) {
                request.performRequest(Util.getCurrentAuthToken(this.authProvider), Util.getCurrentAppCheckToken(this.appCheckProvider), this.context);
                continue;
            }
            request.performRequestStart(Util.getCurrentAuthToken(this.authProvider), Util.getCurrentAppCheckToken(this.appCheckProvider));
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public void reset() {
        this.canceled = false;
    }
}

