/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseException;
import com.google.firebase.storage.CancelException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StorageException
extends FirebaseException {
    private static final String TAG = "StorageException";
    public static final int ERROR_UNKNOWN = -13000;
    public static final int ERROR_OBJECT_NOT_FOUND = -13010;
    public static final int ERROR_BUCKET_NOT_FOUND = -13011;
    public static final int ERROR_PROJECT_NOT_FOUND = -13012;
    public static final int ERROR_QUOTA_EXCEEDED = -13013;
    public static final int ERROR_NOT_AUTHENTICATED = -13020;
    public static final int ERROR_NOT_AUTHORIZED = -13021;
    public static final int ERROR_RETRY_LIMIT_EXCEEDED = -13030;
    public static final int ERROR_INVALID_CHECKSUM = -13031;
    public static final int ERROR_CANCELED = -13040;
    private static final int NETWORK_UNAVAILABLE = -2;
    private final int errorCode;
    private final int httpResultCode;
    private Throwable cause;

    StorageException(int errorCode, Throwable inner, int httpResultCode) {
        super(StorageException.getErrorMessageForCode(errorCode));
        this.cause = inner;
        this.errorCode = errorCode;
        this.httpResultCode = httpResultCode;
        Log.e((String)TAG, (String)("StorageException has occurred.\n" + StorageException.getErrorMessageForCode(errorCode) + "\n Code: " + this.errorCode + " HttpResult: " + this.httpResultCode));
        if (this.cause != null) {
            Log.e((String)TAG, (String)this.cause.getMessage(), (Throwable)this.cause);
        }
    }

    private static int calculateErrorCode(Status status) {
        if (status.isCanceled()) {
            return -13040;
        }
        if (status.equals((Object)Status.RESULT_TIMEOUT)) {
            return -13030;
        }
        return -13000;
    }

    private static int calculateErrorCode(@Nullable Throwable inner, int httpResultCode) {
        if (inner instanceof CancelException) {
            return -13040;
        }
        switch (httpResultCode) {
            case -2: {
                return -13030;
            }
            case 401: {
                return -13020;
            }
            case 403: {
                return -13021;
            }
            case 404: {
                return -13010;
            }
            case 409: {
                return -13031;
            }
        }
        return -13000;
    }

    @NonNull
    public static StorageException fromErrorStatus(@NonNull Status status) {
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkArgument((!status.isSuccess() ? 1 : 0) != 0);
        return new StorageException(StorageException.calculateErrorCode(status), null, 0);
    }

    @Nullable
    public static StorageException fromExceptionAndHttpCode(@Nullable Throwable exception, int httpResultCode) {
        if (exception instanceof StorageException) {
            return (StorageException)((Object)exception);
        }
        if (StorageException.isResultSuccess(httpResultCode) && exception == null) {
            return null;
        }
        return new StorageException(StorageException.calculateErrorCode(exception, httpResultCode), exception, httpResultCode);
    }

    @NonNull
    public static StorageException fromException(@NonNull Throwable exception) {
        StorageException se = StorageException.fromExceptionAndHttpCode(exception, 0);
        assert (se != null);
        return se;
    }

    private static boolean isResultSuccess(int resultCode) {
        return resultCode == 0 || resultCode >= 200 && resultCode < 300;
    }

    static String getErrorMessageForCode(int errorCode) {
        switch (errorCode) {
            case -13000: {
                return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
            }
            case -13010: {
                return "Object does not exist at location.";
            }
            case -13011: {
                return "Bucket does not exist.";
            }
            case -13012: {
                return "Project does not exist.";
            }
            case -13013: {
                return "Quota for bucket exceeded, please view quota on www.firebase.google.com/storage.";
            }
            case -13020: {
                return "User is not authenticated, please authenticate using Firebase Authentication and try again.";
            }
            case -13021: {
                return "User does not have permission to access this object.";
            }
            case -13030: {
                return "The operation retry limit has been exceeded.";
            }
            case -13031: {
                return "Object has a checksum which does not match. Please retry the operation.";
            }
            case -13040: {
                return "The operation was cancelled.";
            }
        }
        return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
    }

    @Nullable
    public synchronized Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getHttpResultCode() {
        return this.httpResultCode;
    }

    public boolean getIsRecoverableException() {
        return this.getErrorCode() == -13030;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

