/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.internal.SlashUtil;
import com.google.firebase.storage.network.ResumableNetworkRequest;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.json.JSONObject;

public class ResumableUploadStartRequest
extends ResumableNetworkRequest {
    private final JSONObject metadata;
    private final String contentType;

    public ResumableUploadStartRequest(@NonNull Uri gsUri, @NonNull FirebaseApp app, @Nullable JSONObject metadata, @NonNull String contentType) {
        super(gsUri, app);
        this.metadata = metadata;
        this.contentType = contentType;
        if (TextUtils.isEmpty((CharSequence)this.contentType)) {
            this.mException = new IllegalArgumentException("mContentType is null or empty");
        }
        super.setCustomHeader("X-Goog-Upload-Protocol", "resumable");
        super.setCustomHeader("X-Goog-Upload-Command", "start");
        super.setCustomHeader("X-Goog-Upload-Header-Content-Type", this.contentType);
    }

    @Override
    @NonNull
    protected String getURL() {
        return sUploadUrl + this.mGsUri.getAuthority() + "/o";
    }

    @Override
    @NonNull
    protected String getAction() {
        return "POST";
    }

    @Override
    @NonNull
    protected String getQueryParameters() throws UnsupportedEncodingException {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String pathWithoutBucket = this.getPathWithoutBucket();
        keys.add("name");
        values.add(pathWithoutBucket != null ? SlashUtil.unSlashize(pathWithoutBucket) : "");
        keys.add("uploadType");
        values.add("resumable");
        return this.getPostDataString(keys, values, false);
    }

    @Override
    @Nullable
    protected JSONObject getOutputJSON() {
        return this.metadata;
    }
}

